/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency;

import com.lumintorious.proficiency.ProficiencyMod;
import com.lumintorious.proficiency.ProficiencyUpdatePacket;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public class ProficiencyCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)"proficiency");
        LiteralArgumentBuilder builder2 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"proficiency", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(command -> {
            Entity patt2732$temp = ((CommandSourceStack)command.getSource()).m_81373_();
            if (patt2732$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt2732$temp;
                player.getCapability(PlayerProficiencies.CAPABILITY).ifPresent(cap -> {
                    Proficiency prof;
                    String profName = (String)command.getArgument("proficiency", String.class);
                    try {
                        prof = Proficiencies.all().stream().filter(p -> p.identifier().equals(profName)).findFirst().orElseThrow(() -> new CommandSyntaxException(new CommandExceptionType(){}, (Message)Component.m_237113_((String)"No such proficiency")));
                    }
                    catch (CommandSyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    cap.setProgress(prof, new Proficiency.Progress((Integer)command.getArgument("level", Integer.class), 0));
                    ProficiencyMod.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ProficiencyUpdatePacket((PlayerProficiencies)cap));
                });
            }
            return 0;
        })));
        return builder2;
    }

    public static class ProficiencyArgumentType
    implements ArgumentType<Proficiency> {
        public Proficiency parse(StringReader reader) throws CommandSyntaxException {
            String str = reader.readString();
            return Proficiencies.all().stream().filter(p -> p.identifier().equals(str)).findFirst().orElseThrow(() -> new CommandSyntaxException(new CommandExceptionType(){}, (Message)Component.m_237113_((String)"No such proficiency")));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            List<Suggestion> list = Proficiencies.all().stream().map(Proficiency::identifier).map(str -> new Suggestion(new StringRange(0, str.length()), str)).toList();
            return CompletableFuture.supplyAsync(() -> Suggestions.create((String)"proficiency", (Collection)list));
        }
    }
}

