/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ProficiencyConfig {
    public static CommonImpl COMMON = ProficiencyConfig.register(ModConfig.Type.COMMON, CommonImpl::new);
    public static ClientImpl CLIENT = ProficiencyConfig.register(ModConfig.Type.CLIENT, ClientImpl::new);

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        return (C)specPair.getLeft();
    }

    public static class CommonImpl {
        public final ForgeConfigSpec.IntValue maxProficiencyLevel;
        public final ForgeConfigSpec.DoubleValue extraResourcesAtBaseMultiplier;
        public final ForgeConfigSpec.DoubleValue baseExperienceMultiplier;
        public final ForgeConfigSpec.DoubleValue extraResourcesPerLevelMultiplier;
        public final ForgeConfigSpec.DoubleValue experiencePerLevelMultiplier;

        CommonImpl(ForgeConfigSpec.Builder builder) {
            this.maxProficiencyLevel = builder.comment("Highest achievable proficiency level.").defineInRange("maxProficiencyLevel", 30, 1, 1000);
            this.extraResourcesAtBaseMultiplier = builder.comment("How much resources are multiplied at level 1. The other levels are not affected by this only as a base.").defineInRange("extraResourcesAtBaseMultiplier", 1.0, (double)0.1f, 10.0);
            this.baseExperienceMultiplier = builder.comment("Experience required for the first level-up. The other levels scale off of this one.").defineInRange("baseExperienceMultiplier", 1.0, (double)0.1f, 10.0);
            this.extraResourcesPerLevelMultiplier = builder.comment("The extra multiplier for resources you get at your proficiency level is multiplied by this. The higher this value, the more resources higher levels yield. The base multiplier is unaffected.").defineInRange("extraResourcesPerLevelMultiplier", 1.0, (double)0.1f, 10.0);
            this.experiencePerLevelMultiplier = builder.comment("The extra experience required each new level is multiplied by this. The higher this value, the more experience higher levels will gain at an increased rate. The base multiplier is unaffected.").defineInRange("experiencePerLevelMultiplier", 1.0, (double)0.1f, 10.0);
        }
    }

    public static class ClientImpl {
        public final ForgeConfigSpec.BooleanValue showInventoryIcon;

        ClientImpl(ForgeConfigSpec.Builder builder) {
            this.showInventoryIcon = builder.comment("Highest achievable proficiency level.").define("showInventoryIcon", true);
        }
    }
}

