/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency;

import com.lumintorious.proficiency.ProficiencyCommand;
import com.lumintorious.proficiency.ProficiencyOps;
import com.lumintorious.proficiency.capability.ChunkPlacementMemory;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import com.lumintorious.proficiency.data.ProficiencySerializer;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.PistonEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;

public class ProficiencyEvents {
    public static void initAll() {
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::handleBlockBreak);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::handleBlockPlace);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onCropGrow);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onSaplingGrow);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onPistonMove);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::registerCapabilities);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onPlayerClone);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onLivingDrops);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onLivingXpDrops);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onPlayerSpawn);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::onAddJsonListeners);
        MinecraftForge.EVENT_BUS.addListener(ProficiencyEvents::handleChunkLoad);
        MinecraftForge.EVENT_BUS.addGenericListener(LevelChunk.class, ProficiencyEvents::handleAddLevelChunkCapability);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, ProficiencyEvents::handleAddPlayerCapability);
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(ProficiencyCommand.create());
    }

    public static void onLivingXpDrops(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null) {
            event.setDroppedExperience(ProficiencyOps.multiplyCharacterXP(event.getAttackingPlayer(), event.getEntity().m_6095_(), event.getDroppedExperience()));
        }
    }

    public static void onLivingDrops(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerProficiencies.CAPABILITY).ifPresent(c -> {
                List<ItemStack> list = event.getDrops().stream().map(ItemEntity::m_32055_).toList();
                List<ItemStack> newList = Proficiency.multiplyDrops(event.getEntity().m_6095_(), list, player, true);
                event.getDrops().addAll(newList.stream().map(stack -> new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), stack)).toList());
            });
        }
    }

    public static void handleSheepSheared(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof IForgeShearable) {
                IForgeShearable shearable = (IForgeShearable)player;
                if (serverPlayer.m_21055_(Items.f_42574_) && shearable.isShearable(serverPlayer.m_21211_(), event.getLevel(), null)) {
                    List drops = shearable.onSheared((Player)serverPlayer, serverPlayer.m_21211_(), event.getLevel(), null, serverPlayer.m_21211_().getEnchantmentLevel(Enchantments.f_44987_));
                    drops.addAll(Proficiency.multiplyDrops(Proficiency.byIdentifier("sheep_wool"), (List<ItemStack>)drops, (Player)serverPlayer, true));
                    for (ItemStack drop : drops) {
                        event.getTarget().m_19983_(drop);
                    }
                }
            }
        }
    }

    public static void onPlayerSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Proficiencies.syncAll(event.getEntity());
            PlayerProficiencies.sync(event.getEntity(), false);
        }
    }

    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(PlayerProficiencies.CAPABILITY).ifPresent(originalCap -> event.getEntity().getCapability(PlayerProficiencies.CAPABILITY).ifPresent(newCap -> {
                newCap.assignAllFrom((PlayerProficiencies)originalCap);
                PlayerProficiencies.sync((Entity)event.getEntity(), false);
            }));
            event.getOriginal().invalidateCaps();
        }
    }

    public static void onSaplingGrow(SaplingGrowTreeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            serverLevel.m_46745_(event.getPos()).getCapability(ChunkPlacementMemory.CAPABILITY).ifPresent(cap -> cap.remove(event.getPos()));
        }
    }

    public static void onCropGrow(BlockEvent.CropGrowEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            serverLevel.m_46745_(event.getPos()).getCapability(ChunkPlacementMemory.CAPABILITY).ifPresent(cap -> cap.remove(event.getPos()));
        }
    }

    public static void onPistonMove(PistonEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            serverLevel.m_46745_(event.getPos()).getCapability(ChunkPlacementMemory.CAPABILITY).ifPresent(cap -> {
                cap.remove(event.getPos());
                cap.save(event.getFaceOffsetPos());
            });
        }
    }

    public static void handleBlockBreak(BlockEvent.BreakEvent event) {
        event.setExpToDrop(ProficiencyOps.multiplyCharacterXP(event.getPlayer(), event.getState(), event.getExpToDrop()));
        ProficiencyOps.breakBlock(event.getPlayer(), event.getPos());
    }

    public static void onAddJsonListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ProficiencySerializer());
    }

    public static void handleBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor;
        if (event.getEntity() instanceof Player && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            serverLevel.m_46745_(event.getPos()).getCapability(ChunkPlacementMemory.CAPABILITY).ifPresent(cap -> cap.save(event.getPos()));
        }
    }

    public static void handleAddLevelChunkCapability(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(ChunkPlacementMemory.KEY, (ICapabilityProvider)new ChunkPlacementMemory());
    }

    public static void handleAddPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(PlayerProficiencies.KEY, (ICapabilityProvider)new PlayerProficiencies());
        }
    }

    public static void handleChunkLoad(ChunkEvent.Load event) {
        ChunkPlacementMemory.periodicCleaning(event.getChunk());
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ChunkPlacementMemory.class);
        event.register(PlayerProficiencies.class);
    }
}

