/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency;

import com.lumintorious.proficiency.ProficiencyConfig;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class ProficiencyUpdatePacket {
    private final PlayerProficiencies proficiencies;
    private final boolean isUpdate;

    public ProficiencyUpdatePacket(PlayerProficiencies proficiencies, boolean isUpdate) {
        this.proficiencies = proficiencies;
        this.isUpdate = isUpdate;
    }

    public ProficiencyUpdatePacket(PlayerProficiencies proficiencies) {
        this.proficiencies = proficiencies;
        this.isUpdate = false;
    }

    public ProficiencyUpdatePacket(FriendlyByteBuf buffer) {
        this.proficiencies = new PlayerProficiencies();
        CompoundTag nbt = buffer.m_130260_();
        this.proficiencies.deserializeNBT(nbt.m_128469_("proficiencies"));
        this.isUpdate = nbt.m_128471_("isUpdate");
    }

    void encode(FriendlyByteBuf buffer) {
        CompoundTag thisTag = new CompoundTag();
        CompoundTag tagCompound = this.proficiencies.serializeNBT();
        thisTag.m_128365_("proficiencies", (Tag)tagCompound);
        thisTag.m_128379_("isUpdate", this.isUpdate);
        buffer.m_130079_(thisTag);
    }

    void handle(NetworkEvent.Context context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(PlayerProficiencies.CAPABILITY).ifPresent(cap -> this.assignAllFromPacket(this.proficiencies, (PlayerProficiencies)cap, this.isUpdate)));
        }
    }

    public void assignAllFromPacket(PlayerProficiencies source, PlayerProficiencies destination, boolean isUpdate) {
        HashMap<Proficiency, Proficiency.Progress> oldProgress = destination.proficiencyProgress;
        destination.assignAllFrom(source);
        if (isUpdate) {
            for (Proficiency prof : Proficiencies.all()) {
                Proficiency.Progress old = oldProgress.get(prof);
                Proficiency.Progress now = destination.proficiencyProgress.get(prof);
                if (now.equals(old)) continue;
                if (now.experience() != 0 || now.level() == 1 || now.level() >= (Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get()) {
                    return;
                }
                if (FMLEnvironment.dist != Dist.CLIENT) continue;
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)("[" + prof.displayName() + "] " + Component.m_237115_((String)"tooltip.proficiency.level_up").getString() + now.level())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            }
        }
    }
}

