/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.data;

import com.lumintorious.proficiency.ProficiencyMod;
import com.lumintorious.proficiency.data.AllProficienciesUpdatePacket;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class Proficiencies {
    private static List<Proficiency> proficiencies = new ArrayList<Proficiency>();

    static void update(List<Proficiency> proficiencies) {
        Proficiencies.proficiencies = proficiencies;
    }

    public static List<Proficiency> all() {
        return new ArrayList<Proficiency>(proficiencies);
    }

    public static void syncAll(Entity potentialPlayer) {
        if (potentialPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)potentialPlayer;
            ProficiencyMod.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new AllProficienciesUpdatePacket(Proficiencies.all()));
        }
    }

    public static Optional<Proficiency> findByBlock(BlockState state) {
        return Proficiencies.all().stream().filter(prof -> prof.type() == Proficiency.Type.BLOCK && prof.affectedBlocks().filter(b -> b == state.m_60734_()).count() > 0L).findFirst();
    }

    public static Optional<Proficiency> findByEntityType(EntityType<?> entityType) {
        return Proficiencies.all().stream().filter(prof -> prof.type() == Proficiency.Type.ENTITY && prof.affectedEntities().anyMatch(e -> e == entityType)).findFirst();
    }

    public static Optional<Proficiency> findByInteractedBlock(BlockState state) {
        return Proficiencies.all().stream().filter(prof -> prof.type() == Proficiency.Type.BLOCK_INTERACT && prof.affectedBlocks().filter(b -> b == state.m_60734_()).count() > 0L).findFirst();
    }

    public static Optional<Proficiency> findByInteractedEntityType(EntityType<?> entityType) {
        return Proficiencies.all().stream().filter(prof -> prof.type() == Proficiency.Type.ENTITY_INTERACT && prof.affectedEntities().anyMatch(e -> e == entityType)).findFirst();
    }
}

