/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.modules;

import com.lumintorious.proficiency.ProficiencyOps;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class BlockActionModule {
    private static HashMap<BlockPos, Map.Entry<Player, Proficiency>> tickTriggerCache = new HashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, BlockActionModule::onItemEntitySpawn);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, BlockActionModule::onPlayerClickBlock);
    }

    public static void onPlayerClickBlock(PlayerInteractEvent event) {
        BlockPos pos = event.getPos();
        BlockState block = event.getLevel().m_8055_(pos);
        Optional<Proficiency> profOpt = Proficiencies.findByInteractedBlock(block);
        profOpt.ifPresent(prof -> {
            tickTriggerCache.put(pos, Map.entry(event.getEntity(), prof));
            System.out.println("Clicking " + prof.displayName());
            event.getEntity().getCapability(PlayerProficiencies.CAPABILITY).ifPresent(cap -> cap.progress((Proficiency)prof));
        });
    }

    public static void onItemEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.m_32055_();
            BlockPos pos = itemEntity.m_20097_();
            if (tickTriggerCache.containsKey(pos)) {
                Map.Entry<Player, Proficiency> entry = tickTriggerCache.get(pos);
                tickTriggerCache.remove(pos);
                Player player = entry.getKey();
                Proficiency proficiency = entry.getValue();
                System.out.println("Handling " + proficiency.displayName());
                List<ItemStack> newDrops = Proficiency.multiplyDrops(proficiency, List.of(stack), player, false);
                ProficiencyOps.dropAll(event.getLevel(), pos, newDrops);
            }
        }
    }
}

