/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency;

import com.lumintorious.proficiency.capability.ChunkPlacementMemory;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ProficiencyOps {
    public static List<ItemStack> allBlockDrops(Player player, BlockPos pos) {
        return ProficiencyOps.allBlockDrops(player, pos, true, true);
    }

    public static List<ItemStack> allBlockDrops(Player player, BlockPos pos, boolean doProgress, boolean repeatForTallBlocks) {
        try {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.m_7500_()) {
                    Optional capOpt = serverLevel.m_46745_(pos).getCapability(ChunkPlacementMemory.CAPABILITY).resolve();
                    if (capOpt.isPresent() && ((ChunkPlacementMemory)capOpt.get()).isManual(pos)) {
                        return List.of();
                    }
                    BlockState state = serverLevel.m_8055_(pos);
                    LootContext.Builder lootContext = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_78972_(LootContextParams.f_81455_, (Object)player);
                    ArrayList<ItemStack> drops = state.m_60724_(lootContext);
                    drops = new ArrayList<ItemStack>(Proficiency.multiplyDrops(state, (List<ItemStack>)drops, player, doProgress));
                    Optional<Proficiency> prof = Proficiency.findByBlock(state);
                    if (prof.isPresent() && prof.get().identifier().equals("tall_crops") && repeatForTallBlocks) {
                        BlockPos bPos = pos.m_7494_();
                        while (player.m_9236_().m_8055_(bPos).m_60734_() == state.m_60734_()) {
                            List<ItemStack> extraDrops = ProficiencyOps.allBlockDrops(player, bPos, doProgress, false);
                            drops.addAll(extraDrops);
                            bPos = bPos.m_7494_();
                        }
                    }
                    return drops;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return List.of();
    }

    public static void breakBlock(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<ItemStack> drops = ProficiencyOps.allBlockDrops(player, pos);
            ProficiencyOps.dropAll((Level)serverLevel, pos, drops);
        }
    }

    public static void dropAll(Level level, BlockPos pos, List<ItemStack> stacks) {
        if (level instanceof ServerLevel) {
            for (ItemStack drop : stacks) {
                ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), drop);
                entity.m_20049_("proficiency:dropped");
                level.m_7967_((Entity)entity);
            }
        }
    }

    public static int multiplyCharacterXP(Player player, EntityType<?> entityType, int xp) {
        Optional<Proficiency> proficiency = Proficiencies.findByEntityType(entityType);
        Optional playerProfs = player.getCapability(PlayerProficiencies.CAPABILITY).resolve();
        if (proficiency.isPresent() && playerProfs.isPresent()) {
            return (int)((float)xp * proficiency.get().getFactorAtLevel(((PlayerProficiencies)playerProfs.get()).getProgress(proficiency.get()).level()));
        }
        return xp;
    }

    public static int multiplyCharacterXP(Player player, BlockState state, int xp) {
        Optional<Proficiency> proficiency = Proficiencies.findByBlock(state);
        Optional playerProfs = player.getCapability(PlayerProficiencies.CAPABILITY).resolve();
        if (proficiency.isPresent() && playerProfs.isPresent()) {
            return (int)((float)xp * proficiency.get().getFactorAtLevel(((PlayerProficiencies)playerProfs.get()).getProgress(proficiency.get()).level()));
        }
        return xp;
    }
}

