/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency;

import com.lumintorious.proficiency.capability.PlayerProficiencies;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ProficiencyUpdatePacket {
    private final PlayerProficiencies proficiencies;
    private final boolean isUpdate;

    public ProficiencyUpdatePacket(PlayerProficiencies proficiencies, boolean isUpdate) {
        this.proficiencies = proficiencies;
        this.isUpdate = isUpdate;
    }

    public ProficiencyUpdatePacket(PlayerProficiencies proficiencies) {
        this.proficiencies = proficiencies;
        this.isUpdate = false;
    }

    public ProficiencyUpdatePacket(FriendlyByteBuf buffer) {
        this.proficiencies = new PlayerProficiencies();
        CompoundTag nbt = buffer.m_130260_();
        this.proficiencies.deserializeNBT(nbt.m_128469_("proficiencies"));
        this.isUpdate = nbt.m_128471_("isUpdate");
    }

    void encode(FriendlyByteBuf buffer) {
        CompoundTag thisTag = new CompoundTag();
        CompoundTag tagCompound = this.proficiencies.serializeNBT();
        thisTag.m_128365_("proficiencies", (Tag)tagCompound);
        thisTag.m_128379_("isUpdate", this.isUpdate);
        buffer.m_130079_(thisTag);
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(PlayerProficiencies.CAPABILITY).ifPresent(cap -> cap.assignAllFromPacket(this.proficiencies, this.isUpdate)));
    }
}

