/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkPlacementMemory
implements ICapabilitySerializable<IntArrayTag> {
    public static final Capability<ChunkPlacementMemory> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkPlacementMemory>(){});
    public static final ResourceLocation KEY = new ResourceLocation("proficiency", "chunk_placement_memory");
    private HashMap<BlockPos, Integer> manuallyPlacedPositions = new HashMap();

    public void save(BlockPos pos) {
        this.manuallyPlacedPositions.put(pos, (int)System.currentTimeMillis() / 86400000);
    }

    public void remove(BlockPos pos) {
        this.manuallyPlacedPositions.remove(pos);
    }

    public boolean isManual(BlockPos pos) {
        return this.manuallyPlacedPositions.containsKey(pos);
    }

    public static void periodicCleaning(ChunkAccess chunk) {
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            levelChunk.getCapability(CAPABILITY).ifPresent(ChunkPlacementMemory::periodicCleaning);
        }
    }

    public void periodicCleaning() {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.manuallyPlacedPositions.entrySet().iterator();
        long currentTimeMillis = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if ((long)entry.getValue().intValue() >= currentTimeMillis - 1209600000L) continue;
            iterator.remove();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CAPABILITY) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }

    public IntArrayTag serializeNBT() {
        int[] intArray = new int[this.manuallyPlacedPositions.size() * 4];
        int index = 0;
        for (Map.Entry<BlockPos, Integer> entry : this.manuallyPlacedPositions.entrySet()) {
            BlockPos pos = entry.getKey();
            Integer time = entry.getValue();
            intArray[index] = time;
            intArray[index] = pos.m_123341_();
            intArray[index] = pos.m_123342_();
            intArray[index] = pos.m_123343_();
            index += 4;
        }
        return new IntArrayTag(intArray);
    }

    public void deserializeNBT(IntArrayTag nbt) {
        if (nbt == null) {
            return;
        }
        int[] intArray = nbt.m_128648_();
        HashMap<BlockPos, Integer> newMap = new HashMap<BlockPos, Integer>();
        for (int i = 0; i < nbt.size(); i += 4) {
            newMap.put(new BlockPos(intArray[1], intArray[2], intArray[3]), intArray[0]);
        }
        this.manuallyPlacedPositions = newMap;
    }
}

