/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.capability;

import com.lumintorious.proficiency.ProficiencyConfig;
import com.lumintorious.proficiency.ProficiencyMod;
import com.lumintorious.proficiency.ProficiencyUpdatePacket;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProficiencies
implements ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    public static final Capability<PlayerProficiencies> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerProficiencies>(){});
    public static final ResourceLocation KEY = new ResourceLocation("proficiency", "player_proficiencies");
    private HashMap<Proficiency, Proficiency.Progress> proficiencyProgress = new HashMap();

    public PlayerProficiencies() {
        for (Proficiency prof : Proficiencies.all()) {
            this.proficiencyProgress.put(prof, new Proficiency.Progress(1, 0));
        }
    }

    public static void sync(Entity potentialPlayer, boolean isUpdate) {
        if (potentialPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)potentialPlayer;
            serverPlayer.getCapability(CAPABILITY).ifPresent(cap -> ProficiencyMod.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProficiencyUpdatePacket((PlayerProficiencies)cap, true)));
        }
    }

    public int size() {
        return this.proficiencyProgress.size();
    }

    public void assignAllFromPacket(PlayerProficiencies proficiencies, boolean isUpdate) {
        HashMap<Proficiency, Proficiency.Progress> oldProgress = this.proficiencyProgress;
        this.assignAllFrom(proficiencies);
        if (isUpdate) {
            for (Proficiency prof : Proficiencies.all()) {
                Proficiency.Progress old = oldProgress.get(prof);
                Proficiency.Progress now = this.proficiencyProgress.get(prof);
                if (now.equals(old)) continue;
            }
        }
    }

    public void assignAllFrom(PlayerProficiencies proficiencies) {
        this.proficiencyProgress = new HashMap();
        for (Proficiency prof : Proficiencies.all()) {
            this.proficiencyProgress.put(prof, new Proficiency.Progress(1, 0));
        }
        this.proficiencyProgress.putAll(proficiencies.proficiencyProgress);
    }

    public void progress(Proficiency proficiency) {
        Proficiency.Progress progress = this.getProgress(proficiency);
        if (progress.level() >= (Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get()) {
            return;
        }
        int requiredXP = proficiency.getExperienceNeededAtLevel(progress.level());
        progress = progress.experience() >= requiredXP - 1 ? new Proficiency.Progress(progress.level() + 1, 0) : new Proficiency.Progress(progress.level(), progress.experience() + 1);
        this.proficiencyProgress.put(proficiency, progress);
    }

    public void setProgress(Proficiency proficiency, Proficiency.Progress progress) {
        this.proficiencyProgress.put(proficiency, progress);
    }

    public Proficiency.Progress getProgress(Proficiency proficiency) {
        return this.proficiencyProgress.getOrDefault(proficiency, new Proficiency.Progress(0, 0));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CAPABILITY) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<Proficiency, Proficiency.Progress> pair : this.proficiencyProgress.entrySet()) {
            if (pair.getKey() == null) continue;
            ListTag listTag = new ListTag();
            listTag.add((Object)IntTag.m_128679_((int)pair.getValue().level()));
            listTag.add((Object)IntTag.m_128679_((int)pair.getValue().experience()));
            compoundTag.m_128365_(pair.getKey().identifier(), (Tag)listTag);
        }
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        HashMap<Proficiency, Proficiency.Progress> newMap = new HashMap<Proficiency, Proficiency.Progress>();
        for (String key : nbt.m_128431_()) {
            try {
                ListTag progress = nbt.m_128437_(key, 3);
                newMap.put(Proficiency.byIdentifier(key), new Proficiency.Progress(progress.m_128763_(0), progress.m_128763_(1)));
            }
            catch (Exception exception) {}
        }
        this.proficiencyProgress = newMap;
    }
}

