/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.client;

import com.lumintorious.proficiency.ProficiencyConfig;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ProficiencyScrollPane
extends AbstractScrollWidget {
    public static final ResourceLocation SECTION_BG = new ResourceLocation("proficiency", "textures/gui/section_v2.png");
    public static final ResourceLocation BAR_EMPTY = new ResourceLocation("proficiency", "textures/gui/bar_empty.png");
    public static final ResourceLocation BAR_FULL = new ResourceLocation("proficiency", "textures/gui/bar_full.png");
    private static double sessionScrollOffset = 0.0;
    private final PlayerProficiencies playerProficiencies;

    public ProficiencyScrollPane(PlayerProficiencies playerProficiencies, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.playerProficiencies = playerProficiencies;
        this.m_240206_(sessionScrollOffset);
        this.m_93692_(true);
    }

    protected int m_239019_() {
        return 178;
    }

    protected boolean m_239656_() {
        return false;
    }

    protected double m_239725_() {
        return 40.0;
    }

    protected int m_239509_() {
        return 4 + 50 * Proficiencies.all().size() - this.m_239019_();
    }

    protected void m_239000_(PoseStack pose, int p_239199_, int p_239200_, float p_239201_) {
        sessionScrollOffset = this.m_239030_();
        int left = this.m_252754_();
        int top = this.m_252907_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int currentX = left + 6;
        int currentY = top + 4;
        Optional cap = player.getCapability(PlayerProficiencies.CAPABILITY).resolve();
        if (cap.isEmpty()) {
            return;
        }
        for (Proficiency proficiency : Proficiencies.all().stream().sorted().toList()) {
            pose.m_85836_();
            pose.m_252880_((float)currentX, (float)currentY, 0.0f);
            this.renderOne(pose, proficiency, ((PlayerProficiencies)cap.get()).getProgress(proficiency));
            pose.m_85849_();
            currentY += 50;
        }
    }

    private void renderItem(PoseStack pose, ItemStack stack, int x, int y) {
        Minecraft.m_91087_().m_91291_().m_274569_(pose, stack, x, y);
    }

    private void renderOne(PoseStack pose, Proficiency proficiency, Proficiency.Progress progress) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)SECTION_BG);
        GuiComponent.m_93133_((PoseStack)pose, (int)-2, (int)0, (float)0.0f, (float)0.0f, (int)192, (int)46, (int)192, (int)46);
        int LIGHT_GRAY = new Color(220, 220, 223).getRGB();
        pose.m_85836_();
        pose.m_252880_(0.5f, -0.75f, 0.0f);
        pose.m_85841_(2.0f, 2.0f, 0.0f);
        this.renderItem(pose, new ItemStack((ItemLike)proficiency.logo(), 1), 1, 2);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 12.0f);
        pose.m_85836_();
        pose.m_252880_(19.0f, 15.0f, 0.0f);
        pose.m_85841_(1.5f, 1.5f, 0.0f);
        MutableComponent level = Component.m_237113_((String)String.valueOf(progress.level()));
        int levelWidth = Minecraft.m_91087_().f_91065_.m_93082_().m_92852_((FormattedText)level);
        Minecraft.m_91087_().f_91065_.m_93082_().m_92763_(pose, (Component)level, 0.0f + -((float)levelWidth / 2.0f), 0.0f, Color.WHITE.getRGB());
        pose.m_85849_();
        String title = proficiency.displayName();
        Minecraft.m_91087_().f_91065_.m_93082_().m_92750_(pose, title, 40.0f, 24.0f, Color.WHITE.getRGB());
        MutableComponent multiplier = Component.m_237113_((String)"x %3.2f".formatted(Float.valueOf(proficiency.getFactorAtLevel(progress.level()))));
        int multiplierWidth = Minecraft.m_91087_().f_91065_.m_93082_().m_92852_((FormattedText)multiplier);
        Minecraft.m_91087_().f_91065_.m_93082_().m_92763_(pose, (Component)multiplier, (float)(184 - multiplierWidth), 24.0f, LIGHT_GRAY);
        pose.m_85836_();
        pose.m_252880_(92.0f, 35.0f, 0.0f);
        pose.m_85836_();
        MutableComponent xp = Component.m_237113_((String)(progress.experience() + "/" + proficiency.getExperienceNeededAtLevel(progress.level())));
        if (progress.level() >= (Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get()) {
            xp = Component.m_237115_((String)"tooltip.proficiency.max_level");
        }
        int xpWidth = Minecraft.m_91087_().f_91065_.m_93082_().m_92852_((FormattedText)xp);
        pose.m_252880_(4.0f, 0.0f, 0.0f);
        pose.m_85841_(0.8f, 0.8f, 0.0f);
        if (progress.level() < (Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get()) {
            Minecraft.m_91087_().f_91065_.m_93082_().m_92763_(pose, (Component)xp, 0.0f - (float)xpWidth / 2.0f, 0.0f, progress.level() >= (Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get() ? Color.GREEN.getRGB() : LIGHT_GRAY);
        }
        pose.m_85849_();
        pose.m_85849_();
        int currentX = 40;
        List<Object> affectedLoot = proficiency.type() == Proficiency.Type.BLOCK || proficiency.type() == Proficiency.Type.BLOCK_INTERACT ? new ArrayList<Item>(proficiency.affectedBlocks().map(Block::m_5456_).toList()) : new ArrayList<Item>(proficiency.affectedItems().toList());
        long timeMs = System.currentTimeMillis();
        long timeS = timeMs / 1000L;
        if (affectedLoot.size() > 5) {
            Collections.shuffle(affectedLoot, new Random(timeS));
            affectedLoot = affectedLoot.subList(0, 5);
        }
        for (Item block : affectedLoot) {
            this.renderItem(pose, new ItemStack((ItemLike)block, 1), currentX, 6);
            currentX += 18;
        }
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(162.0f, 6.0f, 0.0f);
        pose.m_85836_();
        this.renderItem(pose, new ItemStack((ItemLike)proficiency.tool(), 1), 0, 0);
        pose.m_85849_();
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(3.0f, 36.0f, 0.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BAR_EMPTY);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)182, (int)5, (int)182, (int)5);
        float progressFloat = (float)progress.experience() / (float)proficiency.getExperienceNeededAtLevel(progress.level());
        if (progress.level() == ((Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get()).intValue()) {
            progressFloat = 1.0f;
        }
        float progressWidth = progressFloat * 182.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)BAR_FULL);
        GuiComponent.m_93133_((PoseStack)pose, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)((int)progressWidth), (int)5, (int)182, (int)5);
        pose.m_85849_();
    }

    public int getFGColor() {
        return new Color(50, 50, 50).getRGB();
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }
}

