/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.compat.httreechop;

import com.lumintorious.proficiency.ProficiencyOps;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import ht.treechop.api.ChopEvent;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;

public class HTTreeChopCompat {
    private static final HashMap<BlockPos, Map.Entry<List<Proficiency>, List<ItemStack>>> startedPositions = new HashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(HTTreeChopCompat::handleTreeChopStart);
        MinecraftForge.EVENT_BUS.addListener(HTTreeChopCompat::handleTreeChopEnd);
    }

    public static void handleTreeChopStart(ChopEvent.StartChopEvent event) {
        TreeData data = ChopUtil.getTreeBlocks((Level)event.getLevel(), (BlockPos)event.getChoppedBlockPos(), x -> ChopUtil.isBlockALog((Level)event.getLevel(), (BlockPos)x), (int)128);
        ArrayList<ItemStack> startedDrops = new ArrayList<ItemStack>();
        ArrayList profsFound = new ArrayList();
        for (BlockPos pos : data.getLogBlocksOrEmpty()) {
            Optional<Proficiency> prof = Proficiency.findByBlock(event.getLevel().m_8055_(pos));
            prof.ifPresent(profsFound::add);
            startedDrops.addAll(ProficiencyOps.allBlockDrops(event.getPlayer(), pos, false, true));
        }
        startedPositions.put(event.getChoppedBlockPos(), Map.entry(profsFound, startedDrops));
    }

    public static void handleTreeChopEnd(ChopEvent.FinishChopEvent event) {
        if (event.getFelled()) {
            Map.Entry all = startedPositions.getOrDefault(event.getChoppedBlockPos(), Map.entry(List.of(), List.of()));
            startedPositions.remove(event.getChoppedBlockPos());
            event.getPlayer().getCapability(PlayerProficiencies.CAPABILITY).ifPresent(c -> {
                for (Proficiency prof : (List)all.getKey()) {
                    c.progress(prof);
                }
            });
            PlayerProficiencies.sync((Entity)event.getPlayer(), true);
            ProficiencyOps.dropAll(event.getLevel(), event.getChoppedBlockPos(), all.getValue());
        }
    }
}

