/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.data;

import com.lumintorious.proficiency.ProficiencyConfig;
import com.lumintorious.proficiency.ProficiencyMod;
import com.lumintorious.proficiency.ProficiencyUpdatePacket;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record Proficiency(String identifier, String defaultDisplayName, String translationKey, Type type, Item tool, Item logo, int order, float efficiencyPerLevel, int baseXpCost) implements Comparable<Proficiency>
{
    private static final HashMap<Proficiency, TagKey<Block>> blockCache = new HashMap();
    private static final HashMap<Proficiency, TagKey<Item>> itemCache = new HashMap();
    private static final HashMap<Proficiency, TagKey<EntityType<?>>> entityCache = new HashMap();
    private static final Comparator<Proficiency> COMPARATOR = Comparator.comparingInt(Proficiency::order).thenComparing(Comparator.comparingInt(Proficiency::baseXpCost).reversed());

    public static Proficiency byIdentifier(String identifier) {
        return Proficiencies.all().stream().filter(prof -> prof.identifier().equals(identifier)).findFirst().orElse(null);
    }

    public float xpPerLevel() {
        return 0.11f;
    }

    public TagKey<Item> itemTagKey() {
        if (itemCache.containsKey(this)) {
            return itemCache.get(this);
        }
        itemCache.put(this, (TagKey<Item>)ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation("proficiency", "proficiency/" + this.identifier())));
        return itemCache.get(this);
    }

    public TagKey<Block> blockTagKey() {
        if (blockCache.containsKey(this)) {
            return blockCache.get(this);
        }
        blockCache.put(this, (TagKey<Block>)ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("proficiency", "proficiency/" + this.identifier())));
        return blockCache.get(this);
    }

    public TagKey<EntityType<?>> entityTagKey() {
        if (entityCache.containsKey(this)) {
            return entityCache.get(this);
        }
        entityCache.put(this, ForgeRegistries.ENTITY_TYPES.tags().createTagKey(new ResourceLocation("proficiency", "proficiency/" + this.identifier())));
        return entityCache.get(this);
    }

    public String displayName() {
        if (!this.defaultDisplayName().isEmpty()) {
            return this.defaultDisplayName();
        }
        if (!this.translationKey().isEmpty()) {
            return Component.m_237115_((String)this.translationKey()).getString();
        }
        return Component.m_237115_((String)("proficiency." + this.identifier())).getString();
    }

    public Stream<Block> affectedBlocks() {
        return ForgeRegistries.BLOCKS.tags().getTag(this.blockTagKey()).stream();
    }

    public Stream<Item> affectedItems() {
        return ForgeRegistries.ITEMS.tags().getTag(this.itemTagKey()).stream();
    }

    public Stream<EntityType<?>> affectedEntities() {
        return ForgeRegistries.ENTITY_TYPES.tags().getTag(this.entityTagKey()).stream();
    }

    public float getFactorAtLevel(int level) {
        return ((Double)ProficiencyConfig.COMMON.extraResourcesAtBaseMultiplier.get()).floatValue() + (float)(level - 1) * this.efficiencyPerLevel() * ((Double)ProficiencyConfig.COMMON.extraResourcesPerLevelMultiplier.get()).floatValue();
    }

    public int getExperienceNeededAtLevel(int level) {
        if (level < 1) {
            return 0;
        }
        return (int)(Math.pow(1.0f + this.xpPerLevel(), level - 1) * (Double)ProficiencyConfig.COMMON.experiencePerLevelMultiplier.get() * (double)this.baseXpCost * (Double)ProficiencyConfig.COMMON.baseExperienceMultiplier.get());
    }

    public static Optional<Proficiency> findByBlock(BlockState state) {
        return Proficiencies.all().stream().filter(prof -> prof.type() == Type.BLOCK && prof.affectedBlocks().filter(b -> b == state.m_60734_()).count() > 0L).findFirst();
    }

    public static Optional<Proficiency> findByEntityType(EntityType<?> entityType) {
        return Proficiencies.all().stream().filter(prof -> prof.type() == Type.ENTITY && prof.affectedEntities().anyMatch(e -> e == entityType)).findFirst();
    }

    public static List<ItemStack> multiplyDrops(List<ItemStack> stacks, float factor) {
        return stacks.stream().map(ItemStack::m_41777_).peek(stack -> {
            int flatFactor = (int)Math.max(0.0, Math.floor(factor) - 1.0);
            float excessFactor = factor % 1.0f;
            int excess = Math.random() <= (double)excessFactor ? 1 : 0;
            stack.m_41764_(stack.m_41613_() * (flatFactor + excess));
        }).toList();
    }

    public static List<ItemStack> multiplyDrops(Proficiency proficiency, List<ItemStack> stacks, Player player, boolean doProgress) {
        if (proficiency == null) {
            return stacks;
        }
        Optional cap = player.getCapability(PlayerProficiencies.CAPABILITY).resolve();
        if (cap.isEmpty()) {
            return List.of();
        }
        Progress progress = ((PlayerProficiencies)cap.get()).getProgress(proficiency);
        int level = progress.level();
        float factor = proficiency.getFactorAtLevel(level);
        if (doProgress) {
            ((PlayerProficiencies)cap.get()).progress(proficiency);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ProficiencyMod.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProficiencyUpdatePacket((PlayerProficiencies)cap.get()));
        }
        return Proficiency.multiplyDrops(stacks, factor);
    }

    public static List<ItemStack> multiplyDrops(EntityType<?> entityType, List<ItemStack> stacks, Player player, boolean doProgress) {
        Optional<Proficiency> proficiency = Proficiency.findByEntityType(entityType);
        Optional cap = player.getCapability(PlayerProficiencies.CAPABILITY).resolve();
        if (proficiency.isEmpty() || cap.isEmpty()) {
            return List.of();
        }
        Progress progress = ((PlayerProficiencies)cap.get()).getProgress(proficiency.get());
        int level = progress.level();
        float factor = proficiency.get().getFactorAtLevel(level);
        if (doProgress) {
            ((PlayerProficiencies)cap.get()).progress(proficiency.get());
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ProficiencyMod.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProficiencyUpdatePacket((PlayerProficiencies)cap.get()));
        }
        return Proficiency.multiplyDrops(stacks, factor);
    }

    public static List<ItemStack> multiplyDrops(BlockState blockState, List<ItemStack> stacks, Player player, boolean doProgress) {
        Optional<Proficiency> proficiency = Proficiency.findByBlock(blockState);
        Optional cap = player.getCapability(PlayerProficiencies.CAPABILITY).resolve();
        if (proficiency.isEmpty() || cap.isEmpty()) {
            return List.of();
        }
        Progress progress = ((PlayerProficiencies)cap.get()).getProgress(proficiency.get());
        int level = progress.level();
        float factor = proficiency.get().getFactorAtLevel(level);
        if (doProgress) {
            ((PlayerProficiencies)cap.get()).progress(proficiency.get());
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ProficiencyMod.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProficiencyUpdatePacket((PlayerProficiencies)cap.get()));
        }
        return Proficiency.multiplyDrops(stacks, factor);
    }

    public static void sendLevelUpCongratulations(Player player, Proficiency proficiency, Progress progress) {
        if (progress.experience() != 0 || progress.level() == 1 || progress.level() >= (Integer)ProficiencyConfig.COMMON.maxProficiencyLevel.get()) {
            return;
        }
        if (FMLEnvironment.dist == Dist.CLIENT && Minecraft.m_91087_().f_91074_ == player) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)("[" + proficiency.displayName() + "] " + Component.m_237115_((String)"tooltip.proficiency.level_up").getString() + progress.level())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        }
        player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12275_, SoundSource.NEUTRAL, 0.5f, 0.5f);
    }

    @Override
    public int compareTo(@NotNull Proficiency that) {
        return COMPARATOR.compare(this, that);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("identifier", this.identifier());
        tag.m_128359_("type", this.type().name());
        tag.m_128359_("translationKey", this.translationKey());
        tag.m_128359_("defaultDisplayName", this.defaultDisplayName());
        tag.m_128359_("logo", ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)this.logo()).get()).m_135782_().toString());
        tag.m_128359_("tool", ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)this.tool()).get()).m_135782_().toString());
        tag.m_128405_("order", this.order());
        tag.m_128350_("efficiencyPerLevel", this.efficiencyPerLevel());
        tag.m_128405_("baseXpCost", this.baseXpCost());
        return tag;
    }

    public static Proficiency deserialize(CompoundTag tag) {
        return new Proficiency(tag.m_128461_("identifier"), tag.m_128461_("defaultDisplayName"), tag.m_128461_("translationKey"), Type.valueOf(tag.m_128461_("type")), (Item)((Holder.Reference)ForgeRegistries.ITEMS.getDelegate(new ResourceLocation(tag.m_128461_("tool"))).get()).get(), (Item)((Holder.Reference)ForgeRegistries.ITEMS.getDelegate(new ResourceLocation(tag.m_128461_("logo"))).get()).get(), tag.m_128451_("order"), tag.m_128457_("efficiencyPerLevel"), tag.m_128451_("baseXpCost"));
    }

    public static enum Type {
        BLOCK,
        ENTITY,
        BLOCK_INTERACT,
        ENTITY_INTERACT;

    }

    public record Progress(int level, int experience) {
    }
}

