/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ProficiencySerializer
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new Gson();

    public ProficiencySerializer() {
        super(GSON, "proficiency");
    }

    @NotNull
    public Proficiency fromJson(@NotNull ResourceLocation resourceLocation, JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject) {
            JsonObject json = (JsonObject)jsonElement;
            String defaultDisplayName = "";
            if (json.get("defaultDisplayName") != null && json.get("defaultDisplayName").isJsonPrimitive()) {
                defaultDisplayName = json.get("defaultDisplayName").getAsString();
            }
            String translationKey = "";
            if (json.get("translationKey") != null && json.get("translationKey").isJsonPrimitive()) {
                translationKey = json.get("translationKey").getAsString();
            }
            int order = 99999;
            if (json.get("order") != null && json.get("order").isJsonPrimitive()) {
                order = json.get("order").getAsInt();
            }
            return new Proficiency(resourceLocation.m_135815_(), defaultDisplayName, translationKey, Proficiency.Type.valueOf(json.get("type").getAsString()), ForgeRegistries.ITEMS.getDelegate(new ResourceLocation(json.get("tool").getAsString())).map(i -> (Item)i.get()).or(() -> ForgeRegistries.BLOCKS.getDelegate(new ResourceLocation(json.get("tool").getAsString())).map(b -> ((Block)b.get()).m_5456_())).get(), ForgeRegistries.ITEMS.getDelegate(new ResourceLocation(json.get("logo").getAsString())).map(i -> (Item)i.get()).or(() -> ForgeRegistries.BLOCKS.getDelegate(new ResourceLocation(json.get("logo").getAsString())).map(b -> ((Block)b.get()).m_5456_())).get(), order, json.get("efficiencyPerLevel").getAsFloat(), json.get("baseXpCost").getAsInt());
        }
        throw new RuntimeException("Cannot parse JSON " + resourceLocation);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profilerFiller) {
        ArrayList<Proficiency> list = new ArrayList<Proficiency>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey().m_135827_())) continue;
            list.removeIf(p -> p.identifier().equals(((ResourceLocation)entry.getKey()).m_135815_()));
            if (!entry.getValue().isJsonObject()) continue;
            list.add(this.fromJson(entry.getKey(), entry.getValue()));
        }
        Proficiencies.update(list);
    }
}

