/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.proficiency.modules;

import com.lumintorious.proficiency.ProficiencyOps;
import com.lumintorious.proficiency.capability.PlayerProficiencies;
import com.lumintorious.proficiency.data.Proficiencies;
import com.lumintorious.proficiency.data.Proficiency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class EntityInteractModule {
    private static HashMap<Entity, Map.Entry<Player, Proficiency>> tickTriggerCache = new HashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, EntityInteractModule::onItemEntitySpawn);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, EntityInteractModule::onPlayerClickEntity);
    }

    public static void onPlayerClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getLevel() instanceof ServerLevel) {
            Entity entity = event.getTarget();
            if (entity.m_6095_() == EntityType.f_20461_) {
                return;
            }
            BlockPos pos = event.getPos();
            Optional<Proficiency> profOpt = Proficiencies.findByInteractedEntityType(entity.m_6095_());
            profOpt.ifPresent(prof -> {
                tickTriggerCache.put(entity, Map.entry(event.getEntity(), prof));
                event.getEntity().getCapability(PlayerProficiencies.CAPABILITY).ifPresent(cap -> cap.progress((Proficiency)prof));
            });
        }
    }

    public static void onItemEntitySpawn(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        Entity entity;
        if (event.getLevel() instanceof ServerLevel && (entity = event.getEntity()) instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_19880_().contains("proficiency:dropped")) {
            ItemStack stack = itemEntity.m_32055_();
            BlockPos pos = itemEntity.m_20097_();
            for (Map.Entry<Entity, Map.Entry<Player, Proficiency>> entry : tickTriggerCache.entrySet()) {
                Entity entity2 = entry.getKey();
                Player player = entry.getValue().getKey();
                Proficiency proficiency = entry.getValue().getValue();
                if (!(entity2.m_20270_(event.getEntity()) < 3.0f)) continue;
                new Thread(() -> {
                    long levelAge = event.getLevel().m_46467_();
                    try {
                        while (event.getLevel().m_46467_() == levelAge) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    tickTriggerCache.remove(entity2);
                }).start();
                List<ItemStack> newDrops = Proficiency.multiplyDrops(proficiency, List.of(stack), player, false);
                ProficiencyOps.dropAll(event.getLevel(), pos, newDrops);
                break;
            }
        }
    }
}

