/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.xtracr.realcamera.api.VirtualRenderer;
import com.xtracr.realcamera.compat.PehkuiCompat;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import com.xtracr.realcamera.mixins.CameraAccessor;
import com.xtracr.realcamera.mixins.PlayerEntityRendererAccessor;
import com.xtracr.realcamera.utils.MathUtils;
import com.xtracr.realcamera.utils.Matrix3fc;
import net.minecraft.class_1007;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_746;

public class RealCameraCore {
    private static final ModConfig config = ConfigFile.modConfig;
    private static float cameraRoll = 0.0f;
    public static String status = "Successful";
    public static boolean isRenderingWorld = false;

    public static float getRoll() {
        return cameraRoll;
    }

    public static boolean isActive() {
        class_310 client = class_310.method_1551();
        return config.isEnabled() && client.field_1690.method_31044().method_31034() && client.field_1773.method_19418() != null && client.field_1724 != null && !config.isDisabledWhen(client.field_1724);
    }

    public static void updateCamera(class_4184 camera, class_310 client, float tickDelta) {
        cameraRoll = 0.0f;
        if (config.isRendering() && !config.onlyDisableRenderingWhen(client.field_1724)) {
            ((CameraAccessor)camera).setThirdPerson(true);
        }
        if (config.isClassic()) {
            RealCameraCore.classicModeUpdate(camera, client, tickDelta);
        } else {
            RealCameraCore.bindingModeUpdate(camera, client, tickDelta);
        }
    }

    private static void classicModeUpdate(class_4184 camera, class_310 client, float tickDelta) {
        CameraAccessor cameraAccessor = (CameraAccessor)camera;
        class_746 player = client.field_1724;
        float centerYaw = camera.method_19330();
        float pitch = camera.method_19329() + config.getClassicPitch();
        float yaw = centerYaw - config.getClassicYaw();
        cameraRoll = config.getClassicRoll();
        class_243 refer = new class_243(config.getClassicRX(), config.getClassicRY(), config.getClassicRZ()).method_1021(config.getScale());
        class_243 offset = new class_243(config.getClassicX(), config.getClassicY(), config.getClassicZ()).method_1021(config.getScale());
        class_243 center = new class_243(config.getCenterX(), config.getCenterY(), config.getCenterZ()).method_1021(config.getScale());
        if (player.method_5715()) {
            center = center.method_1031(0.0, -0.021875, 0.0);
        }
        if (config.compatPehkui()) {
            refer = PehkuiCompat.scaleVec3d(refer, (class_1297)player, tickDelta);
            offset = PehkuiCompat.scaleVec3d(offset, (class_1297)player, tickDelta);
            center = PehkuiCompat.scaleVec3d(center, (class_1297)player, tickDelta);
        }
        cameraAccessor.invokeSetRotation(centerYaw, 0.0f);
        cameraAccessor.invokeMoveBy(center.method_10216(), center.method_10214(), center.method_10215());
        cameraAccessor.invokeSetRotation(yaw, pitch);
        offset = offset.method_1020(refer);
        cameraAccessor.invokeMoveBy(refer.method_10216(), refer.method_10214(), refer.method_10215());
        class_243 referVec = camera.method_19326();
        cameraAccessor.invokeMoveBy(offset.method_10216(), offset.method_10214(), offset.method_10215());
        RealCameraCore.clipCameraToSpace(camera, referVec);
    }

    private static void bindingModeUpdate(class_4184 camera, class_310 client, float tickDelta) {
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22907(class_1160.field_20703.method_23214(camera.method_19329()));
        matrixStack.method_22907(class_1160.field_20705.method_23214(camera.method_19330() + 180.0f));
        matrixStack.method_23760().method_23762().method_22856();
        class_746 player = client.field_1724;
        if (player.field_6012 == 0) {
            player.field_6038 = player.method_23317();
            player.field_5971 = player.method_23318();
            player.field_5989 = player.method_23321();
        }
        class_243 renderOffset = new class_243(class_3532.method_16436((double)tickDelta, (double)player.field_6038, (double)player.method_23317()), class_3532.method_16436((double)tickDelta, (double)player.field_5971, (double)player.method_23318()), class_3532.method_16436((double)tickDelta, (double)player.field_5989, (double)player.method_23321())).method_1020(camera.method_19326());
        class_1007 playerRenderer = (class_1007)client.method_1561().method_3953((class_1297)player);
        renderOffset = renderOffset.method_1019(playerRenderer.method_23206((class_742)player, tickDelta));
        matrixStack.method_22904(renderOffset.method_10216(), renderOffset.method_10214(), renderOffset.method_10215());
        if (config.compatPehkui()) {
            PehkuiCompat.scaleMatrices(matrixStack, (class_1297)player, tickDelta);
        }
        RealCameraCore.virtualRender((class_742)player, playerRenderer, tickDelta, matrixStack);
        class_1162 refer = new class_1162((float)(config.getBindingRZ() * config.getScale()), -((float)(config.getBindingRY() * config.getScale())), -((float)(config.getBindingRX() * config.getScale())), 1.0f);
        class_1162 offset = new class_1162((float)(config.getBindingZ() * config.getScale()), -((float)(config.getBindingY() * config.getScale())), -((float)(config.getBindingX() * config.getScale())), 1.0f);
        refer.method_22674(matrixStack.method_23760().method_23761());
        offset.method_22674(matrixStack.method_23760().method_23761());
        offset.method_35929(-refer.method_4953(), -refer.method_4956(), -refer.method_4957(), 0.0f);
        ((CameraAccessor)camera).invokeMoveBy(-refer.method_4957(), refer.method_4956(), -refer.method_4953());
        class_243 referVec = camera.method_19326();
        ((CameraAccessor)camera).invokeMoveBy(-offset.method_4957(), offset.method_4956(), -offset.method_4953());
        RealCameraCore.clipCameraToSpace(camera, referVec);
        Matrix3fc normal = new Matrix3fc(matrixStack.method_23760().method_23762()).scale(1.0f, -1.0f, -1.0f);
        normal.rotateLocal((float)Math.toRadians(config.getBindingYaw()), normal.m10, normal.m11, normal.m12);
        normal.rotateLocal((float)Math.toRadians(config.getBindingPitch()), normal.m00, normal.m01, normal.m02);
        normal.rotateLocal((float)Math.toRadians(config.getBindingRoll()), normal.m20, normal.m21, normal.m22);
        class_243 eulerAngle = MathUtils.getEulerAngleYXZ(normal).method_1021(57.29577951308232);
        float pitch = config.isPitchingBound() ? (float)eulerAngle.method_10216() : camera.method_19329() + config.getBindingPitch();
        float yaw = config.isYawingBound() ? (float)eulerAngle.method_10214() : -camera.method_19330() + config.getBindingYaw();
        cameraRoll = config.isRollingBound() ? (float)eulerAngle.method_10215() : config.getBindingRoll();
        ((CameraAccessor)camera).invokeSetRotation(-yaw, pitch);
    }

    private static void clipCameraToSpace(class_4184 camera, class_243 referVec) {
        if (!config.doClipToSpace()) {
            return;
        }
        class_243 offset = camera.method_19326().method_1020(referVec);
        float depth = 0.065f;
        for (int i = 0; i < 8; ++i) {
            float f = 0.065f * (float)((i & 1) * 2 - 1);
            float g = 0.065f * (float)((i >> 1 & 1) * 2 - 1);
            float h = 0.065f * (float)((i >> 2 & 1) * 2 - 1);
            class_243 start = referVec.method_1031((double)f, (double)g, (double)h);
            class_243 end = referVec.method_1019(offset).method_1031((double)f, (double)g, (double)h);
            class_3965 hitResult = ((CameraAccessor)camera).getArea().method_17742(new class_3959(start, end, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, camera.method_19331()));
            double l = hitResult.method_17784().method_1022(start);
            if (hitResult.method_17783() == class_239.class_240.field_1333 || l >= offset.method_1033()) continue;
            offset = offset.method_1021(l / offset.method_1033());
        }
        ((CameraAccessor)camera).invokeSetPos(referVec.method_1019(offset));
    }

    private static void virtualRender(class_742 player, class_1007 playerRenderer, float tickDelta, class_4587 matrixStack) {
        float n;
        class_2350 direction;
        float l;
        if (config.isUsingModModel()) {
            status = "Successful";
            try {
                matrixStack.method_22903();
                if (!VirtualRenderer.virtualRender(tickDelta, matrixStack)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                status = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
                matrixStack.method_22909();
            }
        }
        ((PlayerEntityRendererAccessor)playerRenderer).invokeSetModelPose(player);
        class_591 playerModel = (class_591)playerRenderer.method_4038();
        playerModel.field_3447 = player.method_6055(tickDelta);
        playerModel.field_3449 = player.method_5765();
        playerModel.field_3448 = player.method_6109();
        float h = class_3532.method_17821((float)tickDelta, (float)player.field_6220, (float)player.field_6283);
        float j = class_3532.method_17821((float)tickDelta, (float)player.field_6259, (float)player.field_6241);
        float k = j - h;
        if (player.method_5765() && player.method_5854() instanceof class_1309) {
            class_1309 vehicle = (class_1309)player.method_5854();
            h = class_3532.method_17821((float)tickDelta, (float)vehicle.field_6220, (float)vehicle.field_6283);
            k = j - h;
            l = class_3532.method_15393((float)k);
            if (l < -85.0f) {
                l = -85.0f;
            }
            if (l >= 85.0f) {
                l = 85.0f;
            }
            h = j - l;
            if (l * l > 2500.0f) {
                h += l * 0.2f;
            }
            k = j - h;
        }
        float m = class_3532.method_16439((float)tickDelta, (float)player.field_6004, (float)player.method_36455());
        if (class_1007.method_38563((class_1309)player)) {
            m *= -1.0f;
            k *= -1.0f;
        }
        if (player.method_18376() == class_4050.field_18078 && (direction = player.method_18401()) != null) {
            n = player.method_18381(class_4050.field_18076) - 0.1f;
            matrixStack.method_22904((double)((float)(-direction.method_10148()) * n), 0.0, (double)((float)(-direction.method_10165()) * n));
        }
        l = (float)player.field_6012 + tickDelta;
        ((PlayerEntityRendererAccessor)playerRenderer).invokeSetupTransforms(player, matrixStack, l, h, tickDelta);
        matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
        ((PlayerEntityRendererAccessor)playerRenderer).invokeScale(player, matrixStack, tickDelta);
        matrixStack.method_22904(0.0, (double)-1.501f, 0.0);
        n = 0.0f;
        float o = 0.0f;
        if (!player.method_5765() && player.method_5805()) {
            n = class_3532.method_16439((float)tickDelta, (float)player.field_6211, (float)player.field_6225);
            o = player.field_6249 - player.field_6225 * (1.0f - tickDelta);
            if (player.method_6109()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        }
        playerModel.method_17086((class_1309)player, o, n, tickDelta);
        playerModel.method_17087((class_1309)player, o, n, l, k, m);
        config.getVanillaModelPart().get((class_591<class_742>)((class_591)playerRenderer.method_4038())).method_22703(matrixStack);
    }
}

