/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.xtracr.realcamera.utils.ReflectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_4587;

public class PehkuiCompat {
    public static final boolean loaded = ReflectUtils.isLoaded("virtuoel.pehkui.Pehkui");
    private static final Optional<Method> getModelWidthScale;
    private static final Optional<Method> getModelHeightScale;

    public static void scaleMatrices(class_4587 matrixStack, class_1297 entity, float tickDelta) {
        if (!loaded) {
            return;
        }
        float widthScale = PehkuiCompat.getModelScaleValue(getModelWidthScale, entity, tickDelta);
        float heightScale = PehkuiCompat.getModelScaleValue(getModelHeightScale, entity, tickDelta);
        matrixStack.method_23760().method_23761().method_22672(class_1159.method_24019((float)widthScale, (float)heightScale, (float)widthScale));
    }

    public static class_243 scaleVec3d(class_243 vec3d, class_1297 entity, float tickDelta) {
        if (!loaded) {
            return vec3d;
        }
        float widthScale = PehkuiCompat.getModelScaleValue(getModelWidthScale, entity, tickDelta);
        float heightScale = PehkuiCompat.getModelScaleValue(getModelHeightScale, entity, tickDelta);
        return vec3d.method_18805((double)widthScale, (double)heightScale, (double)widthScale);
    }

    private static float getModelScaleValue(Optional<Method> method, class_1297 entity, float tickDelta) {
        return method.map(mtd -> {
            try {
                return Float.valueOf(((Float)mtd.invoke(null, entity, Float.valueOf(tickDelta))).floatValue());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                return null;
            }
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    static {
        if (loaded) {
            Optional<Class<?>> scaleUtilsClass = ReflectUtils.getClass("virtuoel.pehkui.util.ScaleUtils");
            getModelWidthScale = ReflectUtils.getMethod(scaleUtilsClass, "getModelWidthScale", class_1297.class, Float.TYPE);
            getModelHeightScale = ReflectUtils.getMethod(scaleUtilsClass, "getModelHeightScale", class_1297.class, Float.TYPE);
        } else {
            getModelWidthScale = Optional.empty();
            getModelHeightScale = Optional.empty();
        }
    }
}

