/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.xtracr.realcamera.KeyBindings;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.utils.CrosshairUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        KeyBindings.handle(Minecraft.m_91087_());
    }

    @SubscribeEvent
    public static void onCameraUpdate(EntityViewRenderEvent.CameraSetup event) {
        if (RealCameraCore.isActive()) {
            Camera camera = event.getCamera();
            RealCameraCore.updateCamera(camera, event.getRenderer().m_172797_(), (float)event.getPartialTicks());
            event.setPitch(camera.m_90589_());
            event.setYaw(camera.m_90590_());
            event.setRoll(RealCameraCore.getRoll());
        }
    }

    @SubscribeEvent
    public static void onRenderWorldStage(RenderLevelStageEvent event) {
        if (RenderLevelStageEvent.Stage.AFTER_SKY.equals(event.getStage())) {
            RealCameraCore.isRenderingWorld = true;
            if (ConfigFile.modConfig.isCrosshairDynamic() && RealCameraCore.isActive()) {
                CrosshairUtils.update(Minecraft.m_91087_(), event.getCamera(), event.getPoseStack().m_85850_().m_85861_(), event.getProjectionMatrix());
            }
        } else if (RenderLevelStageEvent.Stage.AFTER_WEATHER.equals(event.getStage())) {
            RealCameraCore.isRenderingWorld = false;
        }
    }
}

