/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.xtracr.realcamera.api.VirtualRenderer;
import com.xtracr.realcamera.compat.PehkuiCompat;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import com.xtracr.realcamera.mixins.CameraAccessor;
import com.xtracr.realcamera.mixins.PlayerEntityRendererAccessor;
import com.xtracr.realcamera.utils.MathUtils;
import com.xtracr.realcamera.utils.Matrix3fc;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RealCameraCore {
    private static final ModConfig config = ConfigFile.modConfig;
    private static float cameraRoll = 0.0f;
    public static String status = "Successful";
    public static boolean isRenderingWorld = false;

    public static float getRoll() {
        return cameraRoll;
    }

    public static boolean isActive() {
        Minecraft client = Minecraft.m_91087_();
        return config.isEnabled() && client.f_91066_.m_92176_().m_90612_() && client.f_91063_.m_109153_() != null && client.f_91074_ != null && !config.isDisabledWhen(client.f_91074_);
    }

    public static void updateCamera(Camera camera, Minecraft client, float tickDelta) {
        cameraRoll = 0.0f;
        if (config.isRendering() && !config.onlyDisableRenderingWhen(client.f_91074_)) {
            ((CameraAccessor)camera).setThirdPerson(true);
        }
        if (config.isClassic()) {
            RealCameraCore.classicModeUpdate(camera, client, tickDelta);
        } else {
            RealCameraCore.bindingModeUpdate(camera, client, tickDelta);
        }
    }

    private static void classicModeUpdate(Camera camera, Minecraft client, float tickDelta) {
        CameraAccessor cameraAccessor = (CameraAccessor)camera;
        LocalPlayer player = client.f_91074_;
        float centerYaw = camera.m_90590_();
        float pitch = camera.m_90589_() + config.getClassicPitch();
        float yaw = centerYaw - config.getClassicYaw();
        cameraRoll = config.getClassicRoll();
        Vec3 refer = new Vec3(config.getClassicRX(), config.getClassicRY(), config.getClassicRZ()).m_82490_(config.getScale());
        Vec3 offset = new Vec3(config.getClassicX(), config.getClassicY(), config.getClassicZ()).m_82490_(config.getScale());
        Vec3 center = new Vec3(config.getCenterX(), config.getCenterY(), config.getCenterZ()).m_82490_(config.getScale());
        if (player.m_6144_()) {
            center = center.m_82520_(0.0, -0.021875, 0.0);
        }
        if (config.compatPehkui()) {
            refer = PehkuiCompat.scaleVec3d(refer, (Entity)player, tickDelta);
            offset = PehkuiCompat.scaleVec3d(offset, (Entity)player, tickDelta);
            center = PehkuiCompat.scaleVec3d(center, (Entity)player, tickDelta);
        }
        cameraAccessor.invokeSetRotation(centerYaw, 0.0f);
        cameraAccessor.invokeMoveBy(center.m_7096_(), center.m_7098_(), center.m_7094_());
        cameraAccessor.invokeSetRotation(yaw, pitch);
        offset = offset.m_82546_(refer);
        cameraAccessor.invokeMoveBy(refer.m_7096_(), refer.m_7098_(), refer.m_7094_());
        Vec3 referVec = camera.m_90583_();
        cameraAccessor.invokeMoveBy(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RealCameraCore.clipCameraToSpace(camera, referVec);
    }

    private static void bindingModeUpdate(Camera camera, Minecraft client, float tickDelta) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
        matrixStack.m_85850_().m_85864_().m_8180_();
        LocalPlayer player = client.f_91074_;
        if (player.f_19797_ == 0) {
            player.f_19790_ = player.m_20185_();
            player.f_19791_ = player.m_20186_();
            player.f_19792_ = player.m_20189_();
        }
        Vec3 renderOffset = new Vec3(Mth.m_14139_((double)tickDelta, (double)player.f_19790_, (double)player.m_20185_()), Mth.m_14139_((double)tickDelta, (double)player.f_19791_, (double)player.m_20186_()), Mth.m_14139_((double)tickDelta, (double)player.f_19792_, (double)player.m_20189_())).m_82546_(camera.m_90583_());
        PlayerRenderer playerRenderer = (PlayerRenderer)client.m_91290_().m_114382_((Entity)player);
        renderOffset = renderOffset.m_82549_(playerRenderer.m_7860_((AbstractClientPlayer)player, tickDelta));
        matrixStack.m_85837_(renderOffset.m_7096_(), renderOffset.m_7098_(), renderOffset.m_7094_());
        if (config.compatPehkui()) {
            PehkuiCompat.scaleMatrices(matrixStack, (Entity)player, tickDelta);
        }
        RealCameraCore.virtualRender((AbstractClientPlayer)player, playerRenderer, tickDelta, matrixStack);
        Vector4f refer = new Vector4f((float)(config.getBindingRZ() * config.getScale()), -((float)(config.getBindingRY() * config.getScale())), -((float)(config.getBindingRX() * config.getScale())), 1.0f);
        Vector4f offset = new Vector4f((float)(config.getBindingZ() * config.getScale()), -((float)(config.getBindingY() * config.getScale())), -((float)(config.getBindingX() * config.getScale())), 1.0f);
        refer.m_123607_(matrixStack.m_85850_().m_85861_());
        offset.m_123607_(matrixStack.m_85850_().m_85861_());
        offset.m_176875_(-refer.m_123601_(), -refer.m_123615_(), -refer.m_123616_(), 0.0f);
        ((CameraAccessor)camera).invokeMoveBy(-refer.m_123616_(), refer.m_123615_(), -refer.m_123601_());
        Vec3 referVec = camera.m_90583_();
        ((CameraAccessor)camera).invokeMoveBy(-offset.m_123616_(), offset.m_123615_(), -offset.m_123601_());
        RealCameraCore.clipCameraToSpace(camera, referVec);
        Matrix3fc normal = new Matrix3fc(matrixStack.m_85850_().m_85864_()).scale(1.0f, -1.0f, -1.0f);
        normal.rotateLocal((float)Math.toRadians(config.getBindingYaw()), normal.m10, normal.m11, normal.m12);
        normal.rotateLocal((float)Math.toRadians(config.getBindingPitch()), normal.m00, normal.m01, normal.m02);
        normal.rotateLocal((float)Math.toRadians(config.getBindingRoll()), normal.m20, normal.m21, normal.m22);
        Vec3 eulerAngle = MathUtils.getEulerAngleYXZ(normal).m_82490_(57.29577951308232);
        float pitch = config.isPitchingBound() ? (float)eulerAngle.m_7096_() : camera.m_90589_() + config.getBindingPitch();
        float yaw = config.isYawingBound() ? (float)eulerAngle.m_7098_() : -camera.m_90590_() + config.getBindingYaw();
        cameraRoll = config.isRollingBound() ? (float)eulerAngle.m_7094_() : config.getBindingRoll();
        ((CameraAccessor)camera).invokeSetRotation(-yaw, pitch);
    }

    private static void clipCameraToSpace(Camera camera, Vec3 referVec) {
        if (!config.doClipToSpace()) {
            return;
        }
        Vec3 offset = camera.m_90583_().m_82546_(referVec);
        float depth = 0.065f;
        for (int i = 0; i < 8; ++i) {
            float f = 0.065f * (float)((i & 1) * 2 - 1);
            float g = 0.065f * (float)((i >> 1 & 1) * 2 - 1);
            float h = 0.065f * (float)((i >> 2 & 1) * 2 - 1);
            Vec3 start = referVec.m_82520_((double)f, (double)g, (double)h);
            Vec3 end = referVec.m_82549_(offset).m_82520_((double)f, (double)g, (double)h);
            BlockHitResult hitResult = ((CameraAccessor)camera).getArea().m_45547_(new ClipContext(start, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.m_90592_()));
            double l = hitResult.m_82450_().m_82554_(start);
            if (hitResult.m_6662_() == HitResult.Type.MISS || l >= offset.m_82553_()) continue;
            offset = offset.m_82490_(l / offset.m_82553_());
        }
        ((CameraAccessor)camera).invokeSetPos(referVec.m_82549_(offset));
    }

    private static void virtualRender(AbstractClientPlayer player, PlayerRenderer playerRenderer, float tickDelta, PoseStack matrixStack) {
        float n;
        Direction direction;
        float l;
        if (config.isUsingModModel()) {
            status = "Successful";
            try {
                matrixStack.m_85836_();
                if (!VirtualRenderer.virtualRender(tickDelta, matrixStack)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                status = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
                matrixStack.m_85849_();
            }
        }
        ((PlayerEntityRendererAccessor)playerRenderer).invokeSetModelPose(player);
        PlayerModel playerModel = (PlayerModel)playerRenderer.m_7200_();
        playerModel.f_102608_ = player.m_21324_(tickDelta);
        playerModel.f_102609_ = player.m_20159_();
        playerModel.f_102610_ = player.m_6162_();
        float h = Mth.m_14189_((float)tickDelta, (float)player.f_20884_, (float)player.f_20883_);
        float j = Mth.m_14189_((float)tickDelta, (float)player.f_20886_, (float)player.f_20885_);
        float k = j - h;
        if (player.m_20159_() && player.m_20202_() instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)player.m_20202_();
            h = Mth.m_14189_((float)tickDelta, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
            k = j - h;
            l = Mth.m_14177_((float)k);
            if (l < -85.0f) {
                l = -85.0f;
            }
            if (l >= 85.0f) {
                l = 85.0f;
            }
            h = j - l;
            if (l * l > 2500.0f) {
                h += l * 0.2f;
            }
            k = j - h;
        }
        float m = Mth.m_14179_((float)tickDelta, (float)player.f_19860_, (float)player.m_146909_());
        if (PlayerRenderer.m_194453_((LivingEntity)player)) {
            m *= -1.0f;
            k *= -1.0f;
        }
        if (player.m_20089_() == Pose.SLEEPING && (direction = player.m_21259_()) != null) {
            n = player.m_20236_(Pose.STANDING) - 0.1f;
            matrixStack.m_85837_((double)((float)(-direction.m_122429_()) * n), 0.0, (double)((float)(-direction.m_122431_()) * n));
        }
        l = (float)player.f_19797_ + tickDelta;
        ((PlayerEntityRendererAccessor)playerRenderer).invokeSetupTransforms(player, matrixStack, l, h, tickDelta);
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        ((PlayerEntityRendererAccessor)playerRenderer).invokeScale(player, matrixStack, tickDelta);
        matrixStack.m_85837_(0.0, (double)-1.501f, 0.0);
        n = 0.0f;
        float o = 0.0f;
        if (!player.m_20159_() && player.m_6084_()) {
            n = Mth.m_14179_((float)tickDelta, (float)player.f_20923_, (float)player.f_20924_);
            o = player.f_20925_ - player.f_20924_ * (1.0f - tickDelta);
            if (player.m_6162_()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        }
        playerModel.m_6839_((LivingEntity)player, o, n, tickDelta);
        playerModel.m_6973_((LivingEntity)player, o, n, l, k, m);
        config.getVanillaModelPart().get((PlayerModel<AbstractClientPlayer>)((PlayerModel)playerRenderer.m_7200_())).m_104299_(matrixStack);
    }
}

