/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.xtracr.realcamera.EventHandler;
import com.xtracr.realcamera.KeyBindings;
import com.xtracr.realcamera.RealCamera;
import com.xtracr.realcamera.compat.EpicFightCompat;
import com.xtracr.realcamera.config.ConfigScreen;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="realcamera")
public class RealCameraForge {
    public RealCameraForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        RealCamera.setup();
        if (ModList.get().isLoaded("epicfight")) {
            EpicFightCompat.register();
        }
        MinecraftForge.EVENT_BUS.addListener(EventHandler::onKeyInput);
        MinecraftForge.EVENT_BUS.addListener(EventHandler::onCameraUpdate);
        MinecraftForge.EVENT_BUS.addListener(EventHandler::onRenderWorldStage);
        if (ModList.get().isLoaded("cloth_config")) {
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((client, parent) -> ConfigScreen.create(parent)));
        }
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.TOGGLE_PERSPECTIVE);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.TOGGLE_ADJUST_MODE);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.TOGGLE_CAMERA_MODE);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.ADJUST_UP);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.ADJUST_DOWN);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.ADJUST_FRONT);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.ADJUST_BACK);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.ADJUST_LEFT);
        ClientRegistry.registerKeyBinding((KeyMapping)KeyBindings.ADJUST_RIGHT);
    }
}

