/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.api;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;

public class VirtualRenderer {
    private static final Map<String, BiPredicate<Float, PoseStack>> functionProvider = new HashMap<String, BiPredicate<Float, PoseStack>>();
    public static final ModConfig config = ConfigFile.modConfig;

    public static void register(String modid, BiPredicate<Float, PoseStack> function) {
        functionProvider.put(modid, function);
    }

    public static String getModelPartName() {
        return config.getModModelPartName();
    }

    public static boolean shouldDisableRender(String modelPartName) {
        ModConfig.Disable.optionalParts.add(modelPartName);
        return RealCameraCore.isRenderingWorld && config.shouldDisableRender(modelPartName) && RealCameraCore.isActive();
    }

    public static boolean virtualRender(float tickDelta, PoseStack matrixStack) {
        return functionProvider.get(config.getModelModID()).test(Float.valueOf(tickDelta), matrixStack);
    }

    public static String[] getModidList() {
        return functionProvider.keySet().toArray(new String[functionProvider.size()]);
    }
}

