/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.xtracr.realcamera.utils.ReflectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PehkuiCompat {
    public static final boolean loaded = ReflectUtils.isLoaded("virtuoel.pehkui.Pehkui");
    private static final Optional<Method> getModelWidthScale;
    private static final Optional<Method> getModelHeightScale;

    public static void scaleMatrices(PoseStack matrixStack, Entity entity, float tickDelta) {
        if (!loaded) {
            return;
        }
        float widthScale = PehkuiCompat.getModelScaleValue(getModelWidthScale, entity, tickDelta);
        float heightScale = PehkuiCompat.getModelScaleValue(getModelHeightScale, entity, tickDelta);
        matrixStack.m_85850_().m_85861_().m_27644_(Matrix4f.m_27632_((float)widthScale, (float)heightScale, (float)widthScale));
    }

    public static Vec3 scaleVec3d(Vec3 vec3d, Entity entity, float tickDelta) {
        if (!loaded) {
            return vec3d;
        }
        float widthScale = PehkuiCompat.getModelScaleValue(getModelWidthScale, entity, tickDelta);
        float heightScale = PehkuiCompat.getModelScaleValue(getModelHeightScale, entity, tickDelta);
        return vec3d.m_82542_((double)widthScale, (double)heightScale, (double)widthScale);
    }

    private static float getModelScaleValue(Optional<Method> method, Entity entity, float tickDelta) {
        return method.map(mtd -> {
            try {
                return Float.valueOf(((Float)mtd.invoke(null, entity, Float.valueOf(tickDelta))).floatValue());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                return null;
            }
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    static {
        if (loaded) {
            Optional<Class<?>> scaleUtilsClass = ReflectUtils.getClass("virtuoel.pehkui.util.ScaleUtils");
            getModelWidthScale = ReflectUtils.getMethod(scaleUtilsClass, "getModelWidthScale", Entity.class, Float.TYPE);
            getModelHeightScale = ReflectUtils.getMethod(scaleUtilsClass, "getModelHeightScale", Entity.class, Float.TYPE);
        } else {
            getModelWidthScale = Optional.empty();
            getModelHeightScale = Optional.empty();
        }
    }
}

