/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xtracr.realcamera.RealCamera;
import com.xtracr.realcamera.config.ModConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;

public class ConfigFile {
    private static final String FILE_NAME = "realcamera.json";
    private static final Path PATH;
    private static final Gson GSON;
    public static final ModConfig modConfig;

    public static void load() {
        try (BufferedReader reader = Files.newBufferedReader(PATH);){
            modConfig.set((ModConfig)GSON.fromJson((Reader)reader, ModConfig.class));
            modConfig.clamp();
        }
        catch (Exception exception) {
            RealCamera.LOGGER.warn("Failed to load realcamera.json");
            ConfigFile.save();
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(PATH, new OpenOption[0]);){
            GSON.toJson((Object)modConfig, (Appendable)writer);
        }
        catch (Exception exception) {
            RealCamera.LOGGER.warn("Failed to save realcamera.json", (Throwable)exception);
            ConfigFile.reset();
        }
    }

    public static void reset() {
        try (BufferedWriter writer = Files.newBufferedWriter(PATH, new OpenOption[0]);){
            modConfig.set(new ModConfig());
            GSON.toJson((Object)modConfig, (Appendable)writer);
        }
        catch (Exception exception) {
            RealCamera.LOGGER.warn("Failed to reset realcamera.json", (Throwable)exception);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        modConfig = new ModConfig();
        File configDir = new File(Minecraft.m_91087_().f_91069_, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        PATH = configDir.toPath().resolve(FILE_NAME);
    }
}

