/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.config;

import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.api.VirtualRenderer;
import com.xtracr.realcamera.compat.DoABarrelRollCompat;
import com.xtracr.realcamera.compat.PehkuiCompat;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import com.xtracr.realcamera.config.VanillaModelPart;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ConfigScreen {
    private static final String CATEGORY = "config.category.xtracr_realcamera_";
    private static final String OPTION = "config.option.xtracr_realcamera_";
    private static final String TOOLTIP = "config.tooltip.xtracr_realcamera_";

    public static Screen create(Screen parent) {
        ConfigFile.load();
        ModConfig config = ConfigFile.modConfig;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).transparentBackground().setSavingRunnable(ConfigFile::save).setTitle((Component)new TranslatableComponent("config.title.xtracr_realcamera"));
        builder.setGlobalized(true);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_general"));
        ConfigCategory binding = builder.getOrCreateCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_binding"));
        ConfigCategory classic = builder.getOrCreateCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_classic"));
        ConfigCategory compats = builder.getOrCreateCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_compats"));
        ConfigCategory disable = builder.getOrCreateCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_disable"));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_enabled"), config.general.enabled).setSaveConsumer(b -> {
            config.general.enabled = b;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_classic"), config.general.classic).setDefaultValue(false).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_classic")}).setSaveConsumer(b -> {
            config.general.classic = b;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_clipToSpace"), config.general.clipToSpace).setDefaultValue(true).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_clipToSpace")}).setSaveConsumer(b -> {
            config.general.clipToSpace = b;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_dynamicCrosshair"), config.general.dynamicCrosshair).setDefaultValue(false).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_dynamicCrosshair")}).setSaveConsumer(b -> {
            config.general.dynamicCrosshair = b;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_renderModel"), config.general.renderModel).setDefaultValue(true).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_renderModel")}).setSaveConsumer(b -> {
            config.general.renderModel = b;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_adjustStep"), config.general.adjustStep).setDefaultValue(0.25).setMin(0.0).setMax(64.0).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_adjustStep")}).setSaveConsumer(d -> {
            config.general.adjustStep = d;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_scale"), config.general.scale).setDefaultValue(1.0).setMin(0.0).setMax(64.0).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_scale")}).setSaveConsumer(d -> {
            config.general.scale = d;
        }).build());
        binding.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)new TranslatableComponent("config.option.xtracr_realcamera_vanillaModelPart"), VanillaModelPart.class, (Enum)config.binding.vanillaModelPart).setDefaultValue((Enum)VanillaModelPart.head).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_vanillaModelPart")}).setSaveConsumer(e -> {
            config.binding.vanillaModelPart = e;
        }).build());
        binding.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_adjustOffset"), config.binding.adjustOffset).setDefaultValue(true).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_adjustOffset")}).setSaveConsumer(b -> {
            config.binding.adjustOffset = b;
        }).build());
        SubCategoryBuilder bindingCameraOffset = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_cameraOffset")).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_bindingOffset"), new TranslatableComponent("config.tooltip.xtracr_realcamera_referOffset"), new TranslatableComponent("config.tooltip.xtracr_realcamera_bindingOffset_n")});
        bindingCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_cameraOffset", new Object[]{"X"}), config.binding.cameraX).setDefaultValue(3.25).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.binding.cameraX = d;
        }).build());
        bindingCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_cameraOffset", new Object[]{"Y"}), config.binding.cameraY).setDefaultValue(2.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.binding.cameraY = d;
        }).build());
        bindingCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_cameraOffset", new Object[]{"Z"}), config.binding.cameraZ).setDefaultValue(0.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.binding.cameraZ = d;
        }).build());
        bindingCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_referOffset", new Object[]{"X"}), config.binding.referX).setDefaultValue(3.25).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.binding.referX = d;
        }).build());
        bindingCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_referOffset", new Object[]{"Y"}), config.binding.referY).setDefaultValue(2.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.binding.referY = d;
        }).build());
        bindingCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_referOffset", new Object[]{"Z"}), config.binding.referZ).setDefaultValue(0.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.binding.referZ = d;
        }).build());
        binding.addEntry((AbstractConfigListEntry)bindingCameraOffset.build());
        SubCategoryBuilder bindingCameraRotation = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_cameraRotation")).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_cameraRotation"), new TranslatableComponent("config.tooltip.xtracr_realcamera_cameraRotation_n")});
        bindingCameraRotation.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_bindPitching"), config.binding.bindPitching).setDefaultValue(true).setSaveConsumer(b -> {
            config.binding.bindPitching = b;
        }).build());
        bindingCameraRotation.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_bindYawing"), config.binding.bindYawing).setDefaultValue(true).setSaveConsumer(b -> {
            config.binding.bindYawing = b;
        }).build());
        bindingCameraRotation.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_bindRolling"), config.binding.bindRolling).setDefaultValue(true).setSaveConsumer(b -> {
            config.binding.bindRolling = b;
        }).build());
        bindingCameraRotation.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent("config.option.xtracr_realcamera_pitch"), config.binding.pitch).setDefaultValue(0.0f).setMin(-180.0f).setMax(180.0f).setSaveConsumer(f -> {
            config.binding.pitch = f.floatValue();
        }).build());
        bindingCameraRotation.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent("config.option.xtracr_realcamera_yaw"), config.binding.yaw).setDefaultValue(0.0f).setMin(-180.0f).setMax(180.0f).setSaveConsumer(f -> {
            config.binding.yaw = f.floatValue();
        }).build());
        bindingCameraRotation.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent("config.option.xtracr_realcamera_roll"), config.binding.roll).setDefaultValue(0.0f).setMin(-180.0f).setMax(180.0f).setSaveConsumer(f -> {
            config.binding.roll = f.floatValue();
        }).build());
        binding.addEntry((AbstractConfigListEntry)bindingCameraRotation.build());
        classic.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)new TranslatableComponent("config.option.xtracr_realcamera_classicAdjustMode"), ModConfig.Classic.AdjustMode.class, (Enum)config.classic.adjustMode).setDefaultValue((Enum)ModConfig.Classic.AdjustMode.CAMERA).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_classicAdjustMode")}).setSaveConsumer(e -> {
            config.classic.adjustMode = e;
        }).build());
        SubCategoryBuilder classicCameraOffset = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_cameraOffset")).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_classicOffset"), new TranslatableComponent("config.tooltip.xtracr_realcamera_referOffset"), new TranslatableComponent("config.tooltip.xtracr_realcamera_classicOffset_n")});
        classicCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_cameraOffset", new Object[]{"X"}), config.classic.cameraX).setDefaultValue(-60.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.cameraX = d;
        }).build());
        classicCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_cameraOffset", new Object[]{"Y"}), config.classic.cameraY).setDefaultValue(2.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.cameraY = d;
        }).build());
        classicCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_cameraOffset", new Object[]{"Z"}), config.classic.cameraZ).setDefaultValue(-16.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.cameraZ = d;
        }).build());
        classicCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_referOffset", new Object[]{"X"}), config.classic.referX).setDefaultValue(3.25).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.referX = d;
        }).build());
        classicCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_referOffset", new Object[]{"Y"}), config.classic.referY).setDefaultValue(2.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.referY = d;
        }).build());
        classicCameraOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_referOffset", new Object[]{"Z"}), config.classic.referZ).setDefaultValue(0.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.referZ = d;
        }).build());
        classic.addEntry((AbstractConfigListEntry)classicCameraOffset.build());
        SubCategoryBuilder classicCenterOffset = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_centerOffset")).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_centerOffset")});
        classicCenterOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_centerOffset", new Object[]{"X"}), config.classic.centerX).setDefaultValue(0.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.centerX = d;
        }).build());
        classicCenterOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_centerOffset", new Object[]{"Y"}), config.classic.centerY).setDefaultValue(-3.4).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.centerY = d;
        }).build());
        classicCenterOffset.add((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)new TranslatableComponent("config.option.xtracr_realcamera_centerOffset", new Object[]{"Z"}), config.classic.centerZ).setDefaultValue(0.0).setMin(-64.0).setMax(64.0).setSaveConsumer(d -> {
            config.classic.centerZ = d;
        }).build());
        classic.addEntry((AbstractConfigListEntry)classicCenterOffset.build());
        SubCategoryBuilder classicCameraRotation = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_cameraRotation")).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_cameraRotation"), new TranslatableComponent("config.tooltip.xtracr_realcamera_cameraRotation_n")});
        classicCameraRotation.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent("config.option.xtracr_realcamera_pitch"), config.classic.pitch).setDefaultValue(0.0f).setMin(-180.0f).setMax(180.0f).setSaveConsumer(f -> {
            config.classic.pitch = f.floatValue();
        }).build());
        classicCameraRotation.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent("config.option.xtracr_realcamera_yaw"), config.classic.yaw).setDefaultValue(18.0f).setMin(-180.0f).setMax(180.0f).setSaveConsumer(f -> {
            config.classic.yaw = f.floatValue();
        }).build());
        classicCameraRotation.add((AbstractConfigListEntry)entryBuilder.startFloatField((Component)new TranslatableComponent("config.option.xtracr_realcamera_roll"), config.classic.roll).setDefaultValue(0.0f).setMin(-180.0f).setMax(180.0f).setSaveConsumer(f -> {
            config.classic.roll = f.floatValue();
        }).build());
        classic.addEntry((AbstractConfigListEntry)classicCameraRotation.build());
        compats.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("config.option.xtracr_realcamera_compatsText_1", new Object[]{new TranslatableComponent("config.option.xtracr_realcamera_compatsText_2").m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("https://github.com/xTracr/RealCamera/wiki/Configuration"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/xTracr/RealCamera/wiki/Configuration#mod-model-compat")))})).build());
        compats.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_useModModel"), config.compats.useModModel).setDefaultValue(false).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_useModModel", new Object[]{new TextComponent(config.compats.useModModel ? RealCameraCore.status : "Disabled").m_130938_(s -> s.m_131140_(config.compats.useModModel ? (RealCameraCore.status == "Successful" ? ChatFormatting.GREEN : ChatFormatting.RED) : ChatFormatting.YELLOW))})}).setSaveConsumer(b -> {
            config.compats.useModModel = b;
        }).build());
        compats.addEntry((AbstractConfigListEntry)entryBuilder.startSelector((Component)new TranslatableComponent("config.option.xtracr_realcamera_modelModID"), (Object[])VirtualRenderer.getModidList(), (Object)config.compats.modelModID).setDefaultValue((Object)"minecraft").setSaveConsumer(s -> {
            config.compats.modelModID = s;
        }).build());
        compats.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((Component)new TranslatableComponent("config.option.xtracr_realcamera_modModelPart"), config.compats.modModelPart).setDefaultValue("head").setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_modModelPart")}).setSaveConsumer(s -> {
            config.compats.modModelPart = s;
        }).build());
        SubCategoryBuilder compatSwitches = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_compatSwitches")).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_compatSwitches")});
        if (DoABarrelRollCompat.loaded) {
            compatSwitches.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_doABarrelRoll"), config.compats.doABarrelRoll).setDefaultValue(true).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_doABarrelRoll")}).setSaveConsumer(b -> {
                config.compats.doABarrelRoll = b;
            }).build());
        }
        if (PehkuiCompat.loaded) {
            compatSwitches.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_pehkui"), config.compats.pehkui).setDefaultValue(true).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_pehkui")}).setSaveConsumer(b -> {
                config.compats.pehkui = b;
            }).build());
        }
        compats.addEntry((AbstractConfigListEntry)compatSwitches.build());
        disable.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_renderModelPart"), config.disable.renderModelPart).setDefaultValue(false).setSaveConsumer(b -> {
            config.disable.renderModelPart = b;
        }).build());
        disable.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((Component)new TranslatableComponent("config.option.xtracr_realcamera_disabledModelParts"), config.disable.disabledModelParts).setDefaultValue(ModConfig.Disable.defaultParts).setTooltip(new Component[]{new TranslatableComponent("config.tooltip.xtracr_realcamera_disabledModelParts", new Object[]{ModConfig.Disable.optionalParts})}).setSaveConsumer(l -> {
            config.disable.disabledModelParts = l;
        }).build());
        SubCategoryBuilder disableModWhen = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_disableModWhen"));
        disableModWhen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_fallFlying"), config.disable.fallFlying).setDefaultValue(true).setSaveConsumer(b -> {
            config.disable.fallFlying = b;
        }).build());
        disableModWhen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_swiming"), config.disable.swiming).setDefaultValue(false).setSaveConsumer(b -> {
            config.disable.swiming = b;
        }).build());
        disableModWhen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_crawling"), config.disable.crawling).setDefaultValue(false).setSaveConsumer(b -> {
            config.disable.crawling = b;
        }).build());
        disableModWhen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_sneaking"), config.disable.sneaking).setDefaultValue(false).setSaveConsumer(b -> {
            config.disable.sneaking = b;
        }).build());
        disableModWhen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_sleeping"), config.disable.sleeping).setDefaultValue(false).setSaveConsumer(b -> {
            config.disable.sleeping = b;
        }).build());
        disable.addEntry((AbstractConfigListEntry)disableModWhen.build());
        SubCategoryBuilder disableRenderWhen = entryBuilder.startSubCategory((Component)new TranslatableComponent("config.category.xtracr_realcamera_disableRenderWhen"));
        disableRenderWhen.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)new TranslatableComponent("config.option.xtracr_realcamera_scoping"), config.disable.scoping).setDefaultValue(true).setSaveConsumer(b -> {
            config.disable.scoping = b;
        }).build());
        disable.addEntry((AbstractConfigListEntry)disableRenderWhen.build());
        return builder.build();
    }
}

