/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.utils;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import com.xtracr.realcamera.utils.Matrix3fc;
import net.minecraft.world.phys.Vec3;

public class MathUtils {
    public static Vec3 getEulerAngleYXZ(Matrix3fc normal) {
        if ((double)normal.m21 <= -1.0) {
            return new Vec3(1.5707963267948966, Math.atan2(normal.m10, normal.m00), 0.0);
        }
        if ((double)normal.m21 >= 1.0) {
            return new Vec3(-1.5707963267948966, -Math.atan2(normal.m10, normal.m00), 0.0);
        }
        double xRot = Math.asin(-normal.m21);
        double cos = Math.cos(xRot);
        double yRot = Math.atan2((double)normal.m20 / cos, (double)normal.m22 / cos);
        double zRot = Math.atan2((double)normal.m01 / cos, (double)normal.m11 / cos);
        return new Vec3(xRot, yRot, zRot);
    }

    public static Vec3 getIntersectionPoint(Vec3 planePoint, Vec3 planeNormal, Vec3 linePoint, Vec3 lineNormal) {
        double distance = planeNormal.m_82526_(planePoint.m_82546_(linePoint)) / planeNormal.m_82526_(lineNormal);
        return linePoint.m_82549_(lineNormal.m_82490_(distance));
    }

    public static Vec3 projectToVec2d(Vec3 vec3d, Matrix4f ... projectionMatrices) {
        Vector4f vector4f = new Vector4f((float)vec3d.m_7096_(), (float)vec3d.m_7098_(), (float)vec3d.m_7094_(), 1.0f);
        for (Matrix4f matrix4f : projectionMatrices) {
            vector4f.m_123607_(matrix4f);
        }
        if ((double)vector4f.m_123617_() == 0.0) {
            return Vec3.f_82478_;
        }
        return new Vec3((double)vector4f.m_123601_(), (double)vector4f.m_123615_(), 0.0).m_82490_(1.0 / (double)vector4f.m_123617_());
    }
}

