/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.utils;

import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;

public class Matrix3fc {
    public float m00;
    public float m10;
    public float m20;
    public float m01;
    public float m11;
    public float m21;
    public float m02;
    public float m12;
    public float m22;

    public Matrix3fc() {
    }

    public Matrix3fc(Matrix3f matrix3f) {
        Vector3f column0 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f column1 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f column2 = new Vector3f(0.0f, 0.0f, 1.0f);
        column0.m_122249_(matrix3f);
        column1.m_122249_(matrix3f);
        column2.m_122249_(matrix3f);
        this.m00 = column0.m_122239_();
        this.m01 = column0.m_122260_();
        this.m02 = column0.m_122269_();
        this.m10 = column1.m_122239_();
        this.m11 = column1.m_122260_();
        this.m12 = column1.m_122269_();
        this.m20 = column2.m_122239_();
        this.m21 = column2.m_122260_();
        this.m22 = column2.m_122269_();
    }

    public Matrix3fc scale(float x, float y, float z) {
        this.m00 *= x;
        this.m01 *= x;
        this.m02 *= x;
        this.m10 *= y;
        this.m11 *= y;
        this.m12 *= y;
        this.m20 *= z;
        this.m21 *= z;
        this.m22 *= z;
        return this;
    }

    public Matrix3fc rotateLocal(float angle, float x, float y, float z) {
        float s = (float)Math.sin(angle);
        float c = (float)Math.cos(angle);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float lm00 = xx * C + c;
        float lm01 = xy * C + z * s;
        float lm02 = xz * C - y * s;
        float lm10 = xy * C - z * s;
        float lm11 = yy * C + c;
        float lm12 = yz * C + x * s;
        float lm20 = xz * C + y * s;
        float lm21 = yz * C - x * s;
        float lm22 = zz * C + c;
        float nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        float nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        float nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        float nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        float nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        float nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        float nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        float nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        float nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m20 = nm20;
        this.m21 = nm21;
        this.m22 = nm22;
        return this;
    }
}

