/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ReflectUtils {
    public static boolean isLoaded(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static boolean isLoaded(String className, String ... classNames) {
        boolean ret = ReflectUtils.isLoaded(className);
        for (String name : classNames) {
            ret = ret || ReflectUtils.isLoaded(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException exception) {
            return Optional.empty();
        }
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(cls -> {
            try {
                Field fld = cls.getField(fieldName);
                fld.setAccessible(true);
                return fld;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    public static Optional<Field> getDeclaredField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(cls -> {
            try {
                Field fld = cls.getDeclaredField(fieldName);
                fld.setAccessible(true);
                return fld;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    public static Optional<Object> getFieldValue(Optional<Field> field, @Nullable Object object) {
        return field.map(fld -> {
            try {
                return fld.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                return null;
            }
        });
    }

    public static void setField(Optional<Field> field, @Nullable Object object, Object value) {
        field.ifPresent(fld -> {
            try {
                fld.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(cls -> {
            try {
                Method mtd = cls.getMethod(methodName, args);
                mtd.setAccessible(true);
                return mtd;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    public static Optional<Method> getDeclaredMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(cls -> {
            try {
                Method mtd = cls.getDeclaredMethod(methodName, args);
                mtd.setAccessible(true);
                return mtd;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }
}

