/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.api;

import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_4587;

public class VirtualRenderer {
    private static final Map<String, BiPredicate<Float, class_4587>> functionProvider = new HashMap<String, BiPredicate<Float, class_4587>>();
    public static final ModConfig config = ConfigFile.modConfig;

    public static void register(String modid, BiPredicate<Float, class_4587> function) {
        functionProvider.put(modid, function);
    }

    public static String getModelPartName() {
        return config.getModModelPartName();
    }

    public static boolean shouldDisableRender(String modelPartName) {
        ModConfig.Disable.optionalParts.add(modelPartName);
        return RealCameraCore.isRenderingWorld && config.shouldDisableRender(modelPartName) && RealCameraCore.isActive();
    }

    public static boolean virtualRender(float tickDelta, class_4587 matrixStack) {
        return functionProvider.get(config.getModelModID()).test(Float.valueOf(tickDelta), matrixStack);
    }

    public static String[] getModidList() {
        return functionProvider.keySet().toArray(new String[functionProvider.size()]);
    }
}

