/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.xtracr.realcamera.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class MC1193Compat {
    public static final boolean is1193;
    private static final Optional<Field> limbAngle;
    private static final Optional<Field> limbDistance;
    private static final Optional<Field> lastLimbDistance;

    public static float getLimbAnimatorSpeed(float tickDelta, LivingEntity entity) {
        float limbDistanceValue = ((Float)ReflectUtils.getFieldValue(limbDistance, entity).get()).floatValue();
        float lastLimbDistanceValue = ((Float)ReflectUtils.getFieldValue(lastLimbDistance, entity).get()).floatValue();
        return Mth.m_14179_((float)tickDelta, (float)lastLimbDistanceValue, (float)limbDistanceValue);
    }

    public static float getLimbAnimatorPos(float tickDelta, LivingEntity entity) {
        float limbAngleValue = ((Float)ReflectUtils.getFieldValue(limbAngle, entity).get()).floatValue();
        float limbDistanceValue = ((Float)ReflectUtils.getFieldValue(limbDistance, entity).get()).floatValue();
        return limbAngleValue - limbDistanceValue * (1.0f - tickDelta);
    }

    static {
        int last = 4;
        try {
            last = ((SemanticVersion)((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion()).getVersionComponent(2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = is1193 = last == 3;
        if (is1193) {
            Optional<Class<?>> livingEntityClass = Optional.of(LivingEntity.class);
            limbAngle = ReflectUtils.getField(livingEntityClass, "field_6249");
            limbDistance = ReflectUtils.getField(livingEntityClass, "field_6225");
            lastLimbDistance = ReflectUtils.getField(livingEntityClass, "field_6211");
        } else {
            limbAngle = Optional.empty();
            limbDistance = Optional.empty();
            lastLimbDistance = Optional.empty();
        }
    }
}

