/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.utils.ReflectUtils;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PehkuiCompat {
    public static final boolean loaded = ReflectUtils.isLoaded("virtuoel.pehkui.Pehkui");
    private static final Optional<Method> getModelWidthScale;
    private static final Optional<Method> getModelHeightScale;

    public static void scaleMatrices(PoseStack matrixStack, Entity entity, float tickDelta) {
        if (!loaded) {
            return;
        }
        float widthScale = ((Float)ReflectUtils.invokeMethod(getModelWidthScale, null, entity, Float.valueOf(tickDelta)).orElse(Float.valueOf(1.0f))).floatValue();
        float heightScale = ((Float)ReflectUtils.invokeMethod(getModelHeightScale, null, entity, Float.valueOf(tickDelta)).orElse(Float.valueOf(1.0f))).floatValue();
        matrixStack.m_85850_().m_252922_().scale(widthScale, heightScale, widthScale);
    }

    public static Vec3 scaleVec3d(Vec3 vec3d, Entity entity, float tickDelta) {
        if (!loaded) {
            return vec3d;
        }
        float widthScale = ((Float)ReflectUtils.invokeMethod(getModelWidthScale, null, entity, Float.valueOf(tickDelta)).orElse(Float.valueOf(1.0f))).floatValue();
        float heightScale = ((Float)ReflectUtils.invokeMethod(getModelHeightScale, null, entity, Float.valueOf(tickDelta)).orElse(Float.valueOf(1.0f))).floatValue();
        return vec3d.m_82542_((double)widthScale, (double)heightScale, (double)widthScale);
    }

    static {
        if (loaded) {
            Optional<Class<?>> scaleUtilsClass = ReflectUtils.getClass("virtuoel.pehkui.util.ScaleUtils");
            getModelWidthScale = ReflectUtils.getMethod(scaleUtilsClass, "getModelWidthScale", Entity.class, Float.TYPE);
            getModelHeightScale = ReflectUtils.getMethod(scaleUtilsClass, "getModelHeightScale", Entity.class, Float.TYPE);
        } else {
            getModelWidthScale = Optional.empty();
            getModelHeightScale = Optional.empty();
        }
    }
}

