/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.config;

import com.xtracr.realcamera.config.VanillaModelPart;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;

public class ModConfig {
    protected static final double MIN_DOUBLE = -64.0;
    protected static final double MAX_DOUBLE = 64.0;
    public General general = new General();
    public Binding binding = new Binding();
    public Classic classic = new Classic();
    public Compats compats = new Compats();
    public Disable disable = new Disable();

    public void set(ModConfig modConfig) {
        this.general = modConfig.general;
        this.binding = modConfig.binding;
        this.classic = modConfig.classic;
        this.compats = modConfig.compats;
        this.disable = modConfig.disable;
    }

    public void clamp() {
        this.general.clamp();
        this.binding.clamp();
        this.classic.clamp();
        if (this.disable.disabledModelParts == null) {
            this.disable.disabledModelParts = Disable.defaultParts;
        }
    }

    public boolean isEnabled() {
        return this.general.enabled;
    }

    public boolean isClassic() {
        return this.general.classic;
    }

    public boolean doClipToSpace() {
        return this.general.clipToSpace;
    }

    public boolean isCrosshairDynamic() {
        return this.general.dynamicCrosshair;
    }

    public boolean isRendering() {
        return this.general.renderModel;
    }

    public double getAdjustStep() {
        return this.general.adjustStep;
    }

    public double getScale() {
        return this.general.scale * 0.0625;
    }

    public void setEnabled(boolean value) {
        this.general.enabled = value;
    }

    public void setClassic(boolean value) {
        this.general.classic = value;
    }

    public VanillaModelPart getVanillaModelPart() {
        return this.binding.vanillaModelPart;
    }

    public boolean isAdjustingOffset() {
        return this.binding.adjustOffset;
    }

    public double getBindingX() {
        return this.binding.cameraX;
    }

    public double getBindingY() {
        return this.binding.cameraY;
    }

    public double getBindingZ() {
        return this.binding.cameraZ;
    }

    public double getBindingRX() {
        return this.binding.referX;
    }

    public double getBindingRY() {
        return this.binding.referY;
    }

    public double getBindingRZ() {
        return this.binding.referZ;
    }

    public boolean isPitchingBound() {
        return this.binding.bindPitching;
    }

    public boolean isYawingBound() {
        return this.binding.bindYawing;
    }

    public boolean isRollingBound() {
        return this.binding.bindRolling;
    }

    public float getBindingPitch() {
        return this.binding.pitch;
    }

    public float getBindingYaw() {
        return this.binding.yaw;
    }

    public float getBindingRoll() {
        return this.binding.roll;
    }

    public void setAdjustOffset(boolean value) {
        this.binding.adjustOffset = value;
    }

    public void adjustBindingX(boolean add) {
        int s;
        int n = s = add ? 1 : -1;
        if (this.isAdjustingOffset()) {
            this.binding.cameraX += (double)s * this.getAdjustStep();
        } else {
            this.binding.roll += (float)(s * 4) * (float)this.getAdjustStep();
        }
        this.binding.clamp();
    }

    public void adjustBindingY(boolean add) {
        int s;
        int n = s = add ? 1 : -1;
        if (this.isAdjustingOffset()) {
            this.binding.cameraY += (double)s * this.getAdjustStep();
        } else {
            this.binding.yaw += (float)(s * 4) * (float)this.getAdjustStep();
        }
        this.binding.clamp();
    }

    public void adjustBindingZ(boolean add) {
        int s;
        int n = s = add ? 1 : -1;
        if (this.isAdjustingOffset()) {
            this.binding.cameraZ += (double)s * this.getAdjustStep();
        } else {
            this.binding.pitch += (float)(s * 4) * (float)this.getAdjustStep();
        }
        this.binding.clamp();
    }

    public Classic.AdjustMode getClassicAdjustMode() {
        return this.classic.adjustMode;
    }

    public double getClassicX() {
        return this.classic.cameraX;
    }

    public double getClassicY() {
        return this.classic.cameraY;
    }

    public double getClassicZ() {
        return this.classic.cameraZ;
    }

    public double getClassicRX() {
        return this.classic.referX;
    }

    public double getClassicRY() {
        return this.classic.referY;
    }

    public double getClassicRZ() {
        return this.classic.referZ;
    }

    public double getCenterX() {
        return this.classic.centerX;
    }

    public double getCenterY() {
        return this.classic.centerY;
    }

    public double getCenterZ() {
        return this.classic.centerZ;
    }

    public float getClassicPitch() {
        return this.classic.pitch;
    }

    public float getClassicYaw() {
        return this.classic.yaw;
    }

    public float getClassicRoll() {
        return this.classic.roll;
    }

    public void cycleClassicAdjustMode() {
        this.classic.adjustMode = this.classic.adjustMode.cycle();
    }

    public void adjustClassicX(boolean add) {
        int s = add ? 1 : -1;
        switch (this.classic.adjustMode) {
            case CENTER: {
                this.classic.centerX += (double)s * this.getAdjustStep();
                break;
            }
            case ROTATION: {
                this.classic.roll += (float)(s * 4) * (float)this.getAdjustStep();
                break;
            }
            default: {
                this.classic.cameraX += (double)s * this.getAdjustStep();
            }
        }
        this.classic.clamp();
    }

    public void adjustClassicY(boolean add) {
        int s = add ? 1 : -1;
        switch (this.classic.adjustMode) {
            case CENTER: {
                this.classic.centerY += (double)s * this.getAdjustStep();
                break;
            }
            case ROTATION: {
                this.classic.yaw += (float)(s * 4) * (float)this.getAdjustStep();
                break;
            }
            default: {
                this.classic.cameraY += (double)s * this.getAdjustStep();
            }
        }
        this.classic.clamp();
    }

    public void adjustClassicZ(boolean add) {
        int s = add ? 1 : -1;
        switch (this.classic.adjustMode) {
            case CENTER: {
                this.classic.centerZ += (double)s * this.getAdjustStep();
                break;
            }
            case ROTATION: {
                this.classic.pitch += (float)(s * 4) * (float)this.getAdjustStep();
                break;
            }
            default: {
                this.classic.cameraZ += (double)s * this.getAdjustStep();
            }
        }
        this.classic.clamp();
    }

    public boolean isUsingModModel() {
        return this.compats.useModModel;
    }

    public String getModelModID() {
        return this.compats.modelModID;
    }

    public String getModModelPartName() {
        return this.compats.modModelPart;
    }

    public boolean compatDoABarrelRoll() {
        return this.compats.doABarrelRoll;
    }

    public boolean compatPehkui() {
        return this.compats.pehkui;
    }

    public boolean compatPhysicsMod() {
        return this.compats.physicsMod;
    }

    public boolean shouldDisableRender(String modelPartName) {
        return this.disable.renderModelPart && this.disable.disabledModelParts.contains(modelPartName);
    }

    public boolean isDisabledWhen(LocalPlayer player) {
        return player.m_21255_() && this.disable.fallFlying || player.m_6069_() && this.disable.swiming || player.m_20143_() && this.disable.crawling || player.m_6144_() && this.disable.sneaking || player.m_5803_() && this.disable.sleeping;
    }

    public boolean onlyDisableRenderingWhen(LocalPlayer player) {
        return player.m_150108_() && this.disable.scoping;
    }

    public class General {
        public boolean enabled = false;
        public boolean classic = false;
        public boolean clipToSpace = true;
        public boolean dynamicCrosshair = false;
        public boolean renderModel = true;
        public double adjustStep = 0.25;
        public double scale = 1.0;

        private void clamp() {
            this.adjustStep = Mth.m_14008_((double)this.adjustStep, (double)0.0, (double)64.0);
            this.scale = Mth.m_14008_((double)this.scale, (double)0.0, (double)64.0);
        }
    }

    public class Binding {
        public VanillaModelPart vanillaModelPart = VanillaModelPart.head;
        public boolean adjustOffset = true;
        public double cameraX = 3.25;
        public double cameraY = 2.0;
        public double cameraZ = 0.0;
        public double referX = 3.25;
        public double referY = 2.0;
        public double referZ = 0.0;
        public boolean bindPitching = true;
        public boolean bindYawing = true;
        public boolean bindRolling = true;
        public float pitch = 0.0f;
        public float yaw = 0.0f;
        public float roll = 0.0f;

        private void clamp() {
            if (!(this.vanillaModelPart instanceof VanillaModelPart)) {
                this.vanillaModelPart = VanillaModelPart.head;
            }
            this.cameraX = Mth.m_14008_((double)this.cameraX, (double)-64.0, (double)64.0);
            this.cameraY = Mth.m_14008_((double)this.cameraY, (double)-64.0, (double)64.0);
            this.cameraZ = Mth.m_14008_((double)this.cameraZ, (double)-64.0, (double)64.0);
            this.referX = Mth.m_14008_((double)this.referX, (double)-64.0, (double)64.0);
            this.referY = Mth.m_14008_((double)this.referY, (double)-64.0, (double)64.0);
            this.referZ = Mth.m_14008_((double)this.referZ, (double)-64.0, (double)64.0);
            this.pitch = Mth.m_14177_((float)this.pitch);
            this.yaw = Mth.m_14177_((float)this.yaw);
            this.roll = Mth.m_14177_((float)this.roll);
        }
    }

    public class Classic {
        public AdjustMode adjustMode = AdjustMode.CAMERA;
        public double cameraX = -60.0;
        public double cameraY = 2.0;
        public double cameraZ = -16.0;
        public double referX = 3.25;
        public double referY = 2.0;
        public double referZ = 0.0;
        public double centerX = 0.0;
        public double centerY = -3.4;
        public double centerZ = 0.0;
        public float pitch = 0.0f;
        public float yaw = 18.0f;
        public float roll = 0.0f;

        private void clamp() {
            if (!(this.adjustMode instanceof AdjustMode)) {
                this.adjustMode = AdjustMode.CAMERA;
            }
            this.cameraX = Mth.m_14008_((double)this.cameraX, (double)-64.0, (double)64.0);
            this.cameraY = Mth.m_14008_((double)this.cameraY, (double)-64.0, (double)64.0);
            this.cameraZ = Mth.m_14008_((double)this.cameraZ, (double)-64.0, (double)64.0);
            this.referX = Mth.m_14008_((double)this.referX, (double)-64.0, (double)64.0);
            this.referY = Mth.m_14008_((double)this.referY, (double)-64.0, (double)64.0);
            this.referZ = Mth.m_14008_((double)this.referZ, (double)-64.0, (double)64.0);
            this.centerX = Mth.m_14008_((double)this.centerX, (double)-64.0, (double)64.0);
            this.centerY = Mth.m_14008_((double)this.centerY, (double)-64.0, (double)64.0);
            this.centerZ = Mth.m_14008_((double)this.centerZ, (double)-64.0, (double)64.0);
            this.pitch = Mth.m_14177_((float)this.pitch);
            this.yaw = Mth.m_14177_((float)this.yaw);
            this.roll = Mth.m_14177_((float)this.roll);
        }

        public static enum AdjustMode {
            CAMERA,
            CENTER,
            ROTATION;

            private static final AdjustMode[] VALUES;

            public AdjustMode cycle() {
                return VALUES[(this.ordinal() + 1) % VALUES.length];
            }

            static {
                VALUES = AdjustMode.values();
            }
        }
    }

    public class Compats {
        public boolean useModModel = false;
        public String modelModID = "minecraft";
        public String modModelPart = "head";
        public boolean doABarrelRoll = true;
        public boolean pehkui = true;
        public boolean physicsMod = true;
    }

    public class Disable {
        protected static final List<String> defaultParts = Arrays.asList("head", "hat", "helmet");
        public static final Set<String> optionalParts = new HashSet<String>(Set.of("head", "hat", "helmet"));
        public boolean renderModelPart = false;
        public List<String> disabledModelParts = defaultParts;
        public boolean fallFlying = true;
        public boolean swiming = false;
        public boolean crawling = false;
        public boolean sneaking = false;
        public boolean sleeping = false;
        public boolean scoping = true;
    }
}

