/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.compat.DoABarrelRollCompat;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.utils.CrosshairUtils;
import com.xtracr.realcamera.utils.RaycastUtils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Unique
    private static boolean toggled = false;
    @Shadow
    @Final
    Minecraft f_109059_;

    @ModifyVariable(method={"updateTargetedEntity"}, at=@At(value="STORE"), ordinal=0)
    private EntityHitResult modifyEntityHitResult(EntityHitResult entityHitResult) {
        CrosshairUtils.capturedEntityHitResult = entityHitResult;
        if (!ConfigFile.modConfig.isCrosshairDynamic() && RealCameraCore.isActive()) {
            Vec3 startVec = RaycastUtils.getStartVec();
            Vec3 endVec = RaycastUtils.getEndVec();
            double sqDistance = this.f_109059_.f_91077_ != null ? this.f_109059_.f_91077_.m_82450_().m_82557_(startVec) : endVec.m_82557_(startVec);
            Entity cameraEntity = this.f_109059_.m_91288_();
            AABB box = cameraEntity.m_20191_().m_82369_(cameraEntity.m_20252_(this.f_109059_.m_91296_()).m_82490_((double)this.f_109059_.f_91072_.m_105286_())).m_82377_(1.0, 1.0, 1.0);
            CrosshairUtils.capturedEntityHitResult = ProjectileUtil.m_37287_((Entity)cameraEntity, (Vec3)startVec, (Vec3)endVec, (AABB)box, entity -> !entity.m_5833_() && entity.m_6087_(), (double)sqDistance);
        }
        return CrosshairUtils.capturedEntityHitResult;
    }

    @Inject(method={"renderHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;push()V")})
    private void setThirdPerson(CallbackInfo cInfo) {
        if (ConfigFile.modConfig.isRendering() && RealCameraCore.isActive()) {
            this.f_109059_.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            toggled = true;
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;pop()V")})
    private void setFirstPerson(CallbackInfo cInfo) {
        if (toggled) {
            this.f_109059_.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            toggled = false;
        }
    }

    @Inject(method={"renderWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V", shift=At.Shift.BY, by=-2)})
    private void onBeforeCameraUpdate(float tickDelta, long limitTime, PoseStack matrixStack, CallbackInfo cInfo) {
        if (ConfigFile.modConfig.compatDoABarrelRoll() && DoABarrelRollCompat.modEnabled() && RealCameraCore.isActive()) {
            matrixStack.m_166856_();
        }
    }
}

