/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common;

import fonnymunkey.simplehats.SimpleHats;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.HatJson;
import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import fonnymunkey.simplehats.util.HatEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;

public class EventHandler {

    @Mod.EventBusSubscriber(modid="simplehats", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlerMod {
        @SubscribeEvent
        public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModRegistry.HATDISPLAYENTITY.get(), HatDisplay.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void registerHats(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                for (HatEntry entry : HatJson.getHatList()) {
                    HatItem hat = entry.getHatDyeSettings().getUseDye() ? new HatItemDyeable(entry) : new HatItem(entry);
                    event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("simplehats", entry.getHatName()), () -> hat);
                    ModRegistry.hatList.add(hat);
                }
                SimpleHats.logger.log(Level.INFO, "Generated " + ModRegistry.hatList.size() + " hat items from hat entries.");
            }
        }

        @SubscribeEvent
        public static void registerCreativeTab(CreativeModeTabEvent.Register event) {
            ModRegistry.HAT_TAB = event.registerCreativeModeTab(new ResourceLocation("simplehats", "simplehats"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)ModRegistry.HATICON.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.simplehats")).m_257501_((features, output, operator) -> {
                output.m_246326_((ItemLike)ModRegistry.HATBAG_COMMON.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_UNCOMMON.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_RARE.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_EPIC.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_EASTER.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_SUMMER.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_HALLOWEEN.get());
                output.m_246326_((ItemLike)ModRegistry.HATBAG_FESTIVE.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_COMMON.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_UNCOMMON.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_RARE.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_EASTER.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_SUMMER.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_HALLOWEEN.get());
                output.m_246326_((ItemLike)ModRegistry.HATSCRAPS_FESTIVE.get());
                output.m_246326_((ItemLike)ModRegistry.HATICON.get());
                output.m_246326_((ItemLike)ModRegistry.HATDISPLAYITEM.get());
                for (HatItem hat : ModRegistry.hatList) {
                    output.m_246326_((ItemLike)hat);
                }
            }));
        }
    }
}

