/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.entity;

import fonnymunkey.simplehats.SimpleHats;
import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.common.item.HatItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class HatDisplay
extends LivingEntity {
    private final NonNullList<ItemStack> hatItemSlots = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.m_135353_(HatDisplay.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public long lastHit;

    public HatDisplay(EntityType<? extends HatDisplay> type, Level level) {
        super(type, level);
    }

    public HatDisplay(Level level, double x, double y, double z) {
        this((EntityType<? extends HatDisplay>)((EntityType)ModRegistry.HATDISPLAYENTITY.get()), level);
        this.m_6034_(x, y, z);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return (ItemStack)this.hatItemSlots.get(0);
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (!stack.m_41619_() && !(stack.m_41720_() instanceof HatItem)) {
            SimpleHats.logger.log(org.apache.logging.log4j.Level.ERROR, "Attempted to place non-hat item \"" + stack.m_41611_() + "\" on hat display stand");
            return;
        }
        this.m_181122_(stack);
        super.m_238392_(EquipmentSlot.HEAD, (ItemStack)this.hatItemSlots.set(0, (Object)stack), stack);
    }

    public boolean m_7066_(ItemStack itemStack) {
        return this.m_6844_(null).m_41619_();
    }

    public Iterable<ItemStack> m_6168_() {
        return this.hatItemSlots;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ListTag listTag = new ListTag();
        ItemStack itemStack = (ItemStack)this.hatItemSlots.get(0);
        CompoundTag compoundTag = new CompoundTag();
        if (!itemStack.m_41619_()) {
            itemStack.m_41739_(compoundTag);
        }
        listTag.add((Object)compoundTag);
        compound.m_128365_("HatItem", (Tag)listTag);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("HatItem", 9)) {
            ListTag listTag = compound.m_128437_("HatItem", 10);
            this.hatItemSlots.set(0, (Object)ItemStack.m_41712_((CompoundTag)listTag.m_128728_(0)));
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_150930_(Items.f_42656_)) {
            if (player.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (this.swapItem(player, itemStack, hand)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private boolean swapItem(Player player, ItemStack stack, InteractionHand hand) {
        ItemStack itemStack = this.m_6844_(null);
        if (!stack.m_41619_() && !(stack.m_41720_() instanceof HatItem)) {
            return false;
        }
        if (player.m_150110_().f_35937_ && itemStack.m_41619_() && !stack.m_41619_()) {
            ItemStack itemStack2 = stack.m_41777_();
            itemStack2.m_41764_(1);
            this.m_8061_(null, itemStack2);
            return true;
        }
        if (!stack.m_41619_() && stack.m_41613_() > 1) {
            if (!itemStack.m_41619_()) {
                return false;
            }
            ItemStack itemStack1 = stack.m_41777_();
            itemStack1.m_41764_(1);
            this.m_8061_(null, itemStack1);
            stack.m_41774_(1);
            return true;
        }
        this.m_8061_(null, stack);
        player.m_21008_(hand, itemStack);
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            if (source.m_269533_(DamageTypeTags.f_268738_)) {
                this.m_6074_();
                return false;
            }
            if (!this.m_6673_(source)) {
                if (source.m_269533_(DamageTypeTags.f_268415_)) {
                    this.brokenByAnything(source);
                    this.m_6074_();
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268727_)) {
                    if (this.m_6060_()) {
                        this.causeDamage(source, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268711_) && this.m_21223_() > 0.5f) {
                    this.causeDamage(source, 4.0f);
                    return false;
                }
                boolean flag = source.m_7640_() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)source.m_7640_()).m_36796_() > 0;
                boolean flag2 = "player".equals(source.m_19385_());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (source.m_19390_()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.m_6074_();
                    return flag1;
                }
                long i = this.f_19853_.m_46467_();
                if (i - this.lastHit > 5L && !flag) {
                    this.f_19853_.m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(source);
                    this.showBreakingParticles();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 32) {
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.f_19853_.m_46467_();
            }
        } else {
            super.m_7822_(id);
        }
    }

    private void showBreakingParticles() {
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.66), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource source, float dmg) {
        float f = this.m_21223_() - dmg;
        if (f <= 0.5f) {
            this.brokenByAnything(source);
            this.m_6074_();
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
        }
    }

    private void brokenByPlayer(DamageSource source) {
        Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)ModRegistry.HATDISPLAYITEM.get()));
        this.brokenByAnything(source);
    }

    private void brokenByAnything(DamageSource source) {
        this.playBrokenSound();
        this.m_6668_(source);
        ItemStack itemStack = (ItemStack)this.hatItemSlots.get(0);
        if (!itemStack.m_41619_()) {
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_().m_7494_(), (ItemStack)itemStack);
            this.hatItemSlots.set(0, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    protected float m_5632_(float f1, float f2) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public double m_6049_() {
        return 0.1;
    }

    public void m_5618_(float offset) {
        this.f_20884_ = this.f_19859_ = offset;
        this.f_20886_ = this.f_20885_ = offset;
    }

    public void m_5616_(float rotation) {
        this.f_20884_ = this.f_19859_ = rotation;
        this.f_20886_ = this.f_20885_ = rotation;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_7313_(Entity entity) {
        return entity instanceof Player && !this.f_19853_.m_7966_((Player)entity, this.m_20183_());
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11683_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6095_().m_20680_();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModRegistry.HATDISPLAYITEM.get());
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_CLIENT_FLAGS.equals(pKey)) {
            this.m_6210_();
            this.f_19850_ = true;
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIENT_FLAGS, (Object)0);
    }
}

