/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swlm.config;

import com.alaharranhonor.swlm.SWLM;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="swlm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockConfigList {
    public static final File BLOCK_CONFIG_FOLDER = FMLPaths.CONFIGDIR.get().resolve("swlm").toFile();
    public static final Multimap<String, ResourceLocation> BLOCK_LIST;
    public static final Map<ResourceLocation, Block> REGISTERED_BLOCKS;
    public static final Map<ResourceLocation, Item> REGISTERED_ITEMS;
    public static final BiMap<ResourceLocation, ResourceLocation> BLOCK_EQUIVALENCE;

    public static void loadConfigBlocks() {
        SWLM.LOGGER.info("Loading Blocks for {} addons", (Object)BLOCK_CONFIG_FOLDER.listFiles().length);
        for (File file : BLOCK_CONFIG_FOLDER.listFiles()) {
            if (!file.getName().contains(".txt")) continue;
            String mod = file.getName().substring(0, file.getName().length() - 4);
            SWLM.LOGGER.info("Loading LM Blocks for {}", (Object)mod);
            if (!ModList.get().isLoaded(mod)) {
                SWLM.LOGGER.info("{} is not loaded", (Object)mod);
                continue;
            }
            String line = null;
            try {
                BufferedReader reader = Files.newBufferedReader(file.toPath());
                while ((line = reader.readLine()) != null) {
                    BLOCK_LIST.put((Object)mod, (Object)new ResourceLocation(line));
                }
            }
            catch (IOException e) {
                SWLM.LOGGER.error((Object)e);
                e.printStackTrace();
            }
            catch (ResourceLocationException rle) {
                SWLM.LOGGER.warn("Invalid block id '{}'", line);
            }
            SWLM.LOGGER.info("Loaded {} LM Blocks for {}", (Object)BLOCK_LIST.get((Object)mod).size(), (Object)mod);
        }
    }

    @SubscribeEvent
    public static void registerConfigBlocks(RegistryEvent.Register<Block> event) {
        BlockConfigList.loadConfigBlocks();
        BLOCK_LIST.values().forEach(addonBlockName -> {
            ResourceLocation swlmBlockName = SWLM.res(addonBlockName.m_135815_());
            Block base = (Block)event.getRegistry().getValue(addonBlockName);
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)base).m_60953_(s -> 15);
            Object block = base instanceof RotatedPillarBlock ? new RotatedPillarBlock(properties) : (base instanceof FallingBlock ? new FallingBlock(properties) : new Block(properties));
            block.m_204297_().m_205769_(base.m_204297_().m_203616_().toList());
            event.getRegistry().register((IForgeRegistryEntry)((Block)block.setRegistryName(swlmBlockName)));
            REGISTERED_BLOCKS.put((ResourceLocation)addonBlockName, (Block)block);
            BLOCK_EQUIVALENCE.put(addonBlockName, (Object)swlmBlockName);
        });
        SWLM.LOGGER.info("Registered {} addon blocks", (Object)REGISTERED_BLOCKS.size());
    }

    @SubscribeEvent
    public static void registerConfigBlockItems(RegistryEvent.Register<Item> event) {
        REGISTERED_BLOCKS.forEach((id, block) -> {
            ResourceLocation path = block.getRegistryName();
            Item item = (Item)new BlockItem(block, new Item.Properties().m_41491_(SWLM.TAB)).setRegistryName(path);
            event.getRegistry().register((IForgeRegistryEntry)item);
            REGISTERED_ITEMS.put((ResourceLocation)id, item);
        });
    }

    static {
        BLOCK_CONFIG_FOLDER.mkdirs();
        BLOCK_LIST = HashMultimap.create();
        REGISTERED_BLOCKS = new HashMap<ResourceLocation, Block>();
        REGISTERED_ITEMS = new HashMap<ResourceLocation, Item>();
        BLOCK_EQUIVALENCE = HashBiMap.create();
    }
}

