/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swlm.util;

import com.alaharranhonor.swlm.config.BlockConfigList;
import com.alaharranhonor.swlm.worldgen.SWLMOreGen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="swlm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeBusEventSubscriber {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(SWLMOreGen::registerConfiguredFeatures);
    }

    @SubscribeEvent
    public static void updateGenTags(TagsUpdatedEvent event) {
        BlockConfigList.REGISTERED_BLOCKS.forEach((baseId, block) -> {
            Block baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(baseId);
            block.m_204297_().m_205769_(baseBlock.m_204297_().m_203616_().toList());
        });
        BlockConfigList.REGISTERED_ITEMS.forEach((baseId, item) -> {
            Item baseItem = (Item)ForgeRegistries.ITEMS.getValue(baseId);
            item.m_204114_().m_205769_(baseItem.m_204114_().m_203616_().toList());
        });
    }

    @SubscribeEvent
    public static void onBlockMissingMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.m_135827_().equalsIgnoreCase("swem") || !mapping.key.m_135815_().contains("star_worm_block")) continue;
            mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("swlm", mapping.key.m_135815_().substring(16)))));
        }
    }

    @SubscribeEvent
    public static void onItemMissingMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.m_135827_().equalsIgnoreCase("swem") || !mapping.key.m_135815_().contains("star_worm_block")) continue;
            mapping.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("swlm", mapping.key.m_135815_().substring(16)))));
        }
    }
}

