/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.cardboardbox.blocks;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wallywhip.cardboardbox.CardboardBox;
import wallywhip.cardboardbox.blocks.CrateTileEntity;
import wallywhip.cardboardbox.compat.TOP.ITOPInfoProvider;
import wallywhip.cardboardbox.init.initBlocks;
import wallywhip.cardboardbox.init.initSounds;

public class CrateBlock
extends BaseEntityBlock
implements ITOPInfoProvider {
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)1.5, (double)9.0, (double)1.5, (double)14.5, (double)13.0, (double)14.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public CrateBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.BLOCK));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Deprecated
    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter p_60556_, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)TYPE) == 0 ? Shapes.m_83144_() : SHAPE;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, FACING});
    }

    @Deprecated
    @NotNull
    public BlockState m_6843_(BlockState p_48722_, Rotation p_48723_) {
        return (BlockState)p_48722_.m_61124_((Property)FACING, (Comparable)p_48723_.m_55954_((Direction)p_48722_.m_61143_((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState m_6943_(BlockState p_48719_, Mirror p_48720_) {
        return p_48719_.m_60717_(p_48720_.m_54846_((Direction)p_48719_.m_61143_((Property)FACING)));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrateTileEntity(pos, state);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity tile;
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() instanceof NameTagItem) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CrateTileEntity) {
                CrateTileEntity crateTile = (CrateTileEntity)blockEntity;
                crateTile.setCustomName(handStack.m_41786_());
                player.m_21011_(hand, !world.f_46443_);
                if (!player.m_7500_()) {
                    handStack.m_41774_(1);
                }
            }
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!CrateBlock.canReplace(world, player, pos, state)) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)tile;
            CompoundTag crateData = crateTile.crateData;
            if (crateData != null) {
                String ss = crateData.m_128461_("Name");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ss));
                if (block instanceof AirBlock) {
                    CardboardBox.LOGGER.warn("Cannot remove Cardboard Box because contents block not found");
                    player.m_5661_((Component)Component.m_237113_((String)"Cannot remove Cardboard Box because contents block not found").m_130940_(ChatFormatting.RED), false);
                    player.m_5661_((Component)Component.m_237113_((String)ss).m_130940_(ChatFormatting.RED), false);
                    world.m_5594_(null, pos, SoundEvents.f_12507_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
                if (crateData.m_128469_("Properties").m_128441_("facing")) {
                    crateData.m_128469_("Properties").m_128359_("facing", player.m_6350_().m_122424_().m_122433_());
                }
                BlockState newState = NbtUtils.m_247651_((HolderGetter)world.m_246945_(Registries.f_256747_), (CompoundTag)crateData);
                world.m_46597_(pos, newState);
                tile = world.m_7702_(pos);
                if (tile != null) {
                    crateData.m_128405_("x", pos.m_123341_());
                    crateData.m_128405_("y", pos.m_123342_());
                    crateData.m_128405_("z", pos.m_123343_());
                    tile.m_142466_(crateData);
                }
            }
            ItemStack stack = new ItemStack((ItemLike)initBlocks.CRATE_BLOCK.get());
            if (crateTile.m_8077_()) {
                stack.m_41714_(crateTile.m_7770_());
            }
            CrateBlock.m_152435_((Level)world, (BlockPos)pos, (Direction)player.m_6350_().m_122424_(), (ItemStack)stack);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean canReplace(Level world, Player player, BlockPos pos, BlockState state) {
        if (world.m_7966_(player, pos)) {
            return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player));
        }
        return false;
    }

    public void m_6402_(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity livingEntity, @Nonnull ItemStack itemStack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)blockEntity;
            if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("CrateData")) {
                crateTile.crateData = itemStack.m_41783_().m_128469_("CrateData");
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(itemStack.m_41783_().m_128451_("CustomModelData"))));
            }
            if (itemStack.m_41788_()) {
                crateTile.setCustomName(itemStack.m_41786_());
            }
        }
    }

    public void m_6240_(@NotNull Level world, @NotNull Player playerEntity, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable BlockEntity tileEntity, @NotNull ItemStack itemStack) {
        super.m_6240_(world, playerEntity, pos, blockState, tileEntity, itemStack);
        if (tileEntity instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)tileEntity;
            ItemStack stack = new ItemStack((ItemLike)initBlocks.CRATE_BLOCK.get());
            stack.m_41784_().m_128365_("CrateData", (Tag)crateTile.crateData);
            stack.m_41783_().m_128405_("CustomModelData", ((Integer)blockState.m_61143_((Property)TYPE)).intValue());
            if (crateTile.m_8077_()) {
                stack.m_41714_(crateTile.m_7770_());
            }
            CrateBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData iProbeHitData) {
        BlockEntity blockEntity = world.m_7702_(iProbeHitData.getPos());
        if (blockEntity instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)blockEntity;
            if (crateTile.crateData != null) {
                String ss = crateTile.crateData.m_128461_("Name");
                if (crateTile.crateData.m_128425_("CustomName", 8)) {
                    iProbeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text((Component)Component.Serializer.m_130701_((String)crateTile.crateData.m_128461_("CustomName"))));
                } else {
                    iProbeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text(crateTile.crateData.m_128461_("Desc")));
                }
                if (ss.equals("minecraft:spawner") && crateTile.crateData.m_128441_("DescM")) {
                    iProbeInfo.text((Component)Component.m_237110_((String)"tip.cardboardbox.mob", (Object[])new Object[]{crateTile.crateData.m_128461_("DescM")}));
                }
                if (ss.equals("minecraft:beehive") || ss.equals("minecraft:bee_nest")) {
                    ListTag nbtList = crateTile.crateData.m_128437_("Bees", 10);
                    iProbeInfo.text((Component)Component.m_237110_((String)"tip.cardboardbox.bee", (Object[])new Object[]{nbtList.size() == 0 ? Component.m_237115_((String)"tip.cardboardbox.empty") : Integer.valueOf(nbtList.size())}));
                    iProbeInfo.text((Component)Component.m_237110_((String)"tip.cardboardbox.bee_level", (Object[])new Object[]{crateTile.crateData.m_128469_("Properties").m_128461_("honey_level")}));
                }
                if (crateTile.crateData.m_128425_("Items", 9)) {
                    ListTag listTag = crateTile.crateData.m_128437_("Items", 10);
                    int listSize = Integer.min(5, listTag.size());
                    for (int i = 0; i < listSize; ++i) {
                        CompoundTag compoundTag = listTag.m_128728_(i);
                        ItemStack item = ItemStack.m_41712_((CompoundTag)compoundTag);
                        MutableComponent mutableComponent = item.m_41786_().m_6881_();
                        mutableComponent.m_130946_(" x").m_130946_(String.valueOf(item.m_41613_()));
                        iProbeInfo.text((Component)mutableComponent);
                    }
                    if (listTag.size() > 5) {
                        iProbeInfo.text((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{listTag.size() - 5}));
                    }
                }
            }
        }
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockReader, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, blockReader, list, tooltipFlag);
        if (itemStack.m_41782_()) {
            CompoundTag crateData = itemStack.m_41783_().m_128469_("CrateData");
            if (crateData.m_128456_()) {
                return;
            }
            String ss = crateData.m_128461_("Name");
            if (crateData.m_128425_("CustomName", 8)) {
                list.add((Component)Component.Serializer.m_130701_((String)crateData.m_128461_("CustomName")).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC));
            } else {
                list.add((Component)Component.m_237113_((String)crateData.m_128461_("Desc")).m_130940_(ChatFormatting.GOLD));
            }
            int nbtLength = CardboardBox.getNBTSize(itemStack.m_41783_());
            int overflow = 0x100000 - nbtLength;
            Object extra = "";
            if (overflow != 0) {
                extra = " (" + overflow + ")";
            }
            if (Screen.m_96638_()) {
                list.add(1, (Component)Component.m_237110_((String)"tip.cardboardbox.nbt", (Object[])new Object[]{nbtLength + " / 1048576" + (String)extra}).m_130940_(nbtLength <= 0x100000 ? ChatFormatting.GREEN : ChatFormatting.RED));
            } else {
                list.add(1, (Component)Component.m_237110_((String)"tip.cardboardbox.nbt", (Object[])new Object[]{nbtLength + (String)extra}).m_130940_(nbtLength <= 0x100000 ? ChatFormatting.GREEN : ChatFormatting.RED));
            }
            if (ss.equals("minecraft:spawner") && crateData.m_128441_("DescM")) {
                list.add((Component)Component.m_237110_((String)"tip.cardboardbox.mob", (Object[])new Object[]{crateData.m_128461_("DescM")}).m_130940_(ChatFormatting.GRAY));
            }
            if (ss.equals("minecraft:beehive") || ss.equals("minecraft:bee_nest")) {
                ListTag nbtList = crateData.m_128437_("Bees", 10);
                list.add((Component)Component.m_237110_((String)"tip.cardboardbox.bee", (Object[])new Object[]{nbtList.size() == 0 ? Component.m_237115_((String)"tip.cardboardbox.empty") : Integer.valueOf(nbtList.size())}).m_130940_(ChatFormatting.GRAY));
                list.add((Component)Component.m_237110_((String)"tip.cardboardbox.bee_level", (Object[])new Object[]{crateData.m_128469_("Properties").m_128461_("honey_level")}).m_130940_(ChatFormatting.GRAY));
            }
            if (crateData.m_128425_("Items", 9)) {
                ListTag listTag = crateData.m_128437_("Items", 10);
                int listSize = Integer.min(5, listTag.size());
                for (int i = 0; i < listSize; ++i) {
                    CompoundTag compoundTag = listTag.m_128728_(i);
                    ItemStack item = ItemStack.m_41712_((CompoundTag)compoundTag);
                    MutableComponent mutableComponent = item.m_41786_().m_6881_();
                    mutableComponent.m_130946_(" x").m_130946_(String.valueOf(item.m_41613_()));
                    list.add((Component)mutableComponent.m_130940_(ChatFormatting.GRAY));
                }
                if (listTag.size() > 5) {
                    list.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{listTag.size() - 5}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    @Deprecated
    @NotNull
    public SoundType m_49962_(BlockState state) {
        if ((Integer)state.m_61143_((Property)TYPE) == 0) {
            return SoundType.f_56736_;
        }
        return initSounds.SOUND_SHAKE;
    }
}

