/*
 * Decompiled with CFR 0.152.
 */
package net.mindshake.witchmobility.item;

import java.util.List;
import java.util.Objects;
import net.mindshake.witchmobility.entity.BroomEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BroomItem<T>
extends Item
implements IAnimatable {
    private final RegistryObject<T> registryObject;
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean screenOpened = false;

    public BroomItem(RegistryObject<T> registryObject, Item.Properties settings) {
        super(settings);
        this.registryObject = registryObject;
    }

    public InteractionResult m_6225_(UseOnContext p_41427_) {
        Level level = p_41427_.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = p_41427_.m_43722_();
        BlockPos blockpos = p_41427_.m_8083_();
        Direction direction = p_41427_.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_142300_(direction);
        EntityType entitytype = (EntityType)this.registryObject.get();
        if (entitytype.m_20592_((ServerLevel)level, itemstack, p_41427_.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            itemstack.m_41774_(1);
            level.m_142346_((Entity)p_41427_.m_43723_(), GameEvent.f_157810_, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        if (p_41422_ != null) {
            EntityType entitytype = (EntityType)this.registryObject.get();
            BroomEntity broomEntity = (BroomEntity)entitytype.m_20615_(p_41422_);
            p_41423_.add((Component)new TranslatableComponent("tooltip.broom.speed", new Object[]{Float.toString(broomEntity.m_6113_())}));
            p_41423_.add((Component)new TranslatableComponent("tooltip.broom.agility", new Object[]{Float.toString(broomEntity.getRotationSpeed())}));
        }
    }

    public void registerControllers(AnimationData animationData) {
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

