/*
 * Decompiled with CFR 0.152.
 */
package net.mindshake.witchmobility.entity;

import java.util.List;
import java.util.Objects;
import net.mindshake.witchmobility.item.armor.WitchHat;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class BroomEntity
extends class_1308
implements IAnimatable {
    protected boolean upIsPressed;
    protected boolean downIsPressed;
    protected class_1657 lastPassenger;
    protected class_1792 sourceItem;
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private float bonusSpeed = 0.0f;
    private float bonusAgility = 0.0f;

    protected BroomEntity(class_1299<? extends class_1308> entityType, class_1937 world, class_1792 sourceItem) {
        super(entityType, world);
        this.method_5875(true);
        this.sourceItem = sourceItem;
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    protected boolean method_5818(class_1297 passenger) {
        List passengers = this.method_5685();
        return passengers.size() < 1;
    }

    public float method_6032() {
        return 0.0f;
    }

    public boolean method_5956() {
        return this.method_5642() instanceof class_1657;
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        if (!this.field_6002.field_9236) {
            boolean isRiding = player.method_5804((class_1297)this);
            this.lastPassenger = isRiding ? player : this.lastPassenger;
            return isRiding ? class_1269.field_21466 : class_1269.field_5814;
        }
        return player.method_5668() == this.method_5668() ? class_1269.field_5814 : class_1269.field_5812;
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            this.upIsPressed = class_310.method_1551().field_1690.field_1903.method_1434();
            this.downIsPressed = class_310.method_1551().field_1690.field_1867.method_1434();
        }
    }

    public void method_6091(class_243 movementInput) {
        if (!this.method_5805()) {
            return;
        }
        if (!this.method_5782() || !this.method_5956()) {
            return;
        }
        this.checkBonusValues();
        class_1309 livingEntity = (class_1309)this.method_5642();
        this.field_5982 = this.method_36454();
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6241 = this.field_6283 = this.method_36454();
        float sideSpeed = livingEntity.field_6212 * this.getRotationSpeed() * (1.0f + this.bonusAgility);
        this.method_36456(this.method_36454() - sideSpeed);
        float forwardSpeed = livingEntity.field_6250;
        float verticalSpeed = 0.0f;
        if (forwardSpeed <= 0.0f) {
            forwardSpeed *= 0.25f;
        }
        if (this.upIsPressed) {
            verticalSpeed = 0.45f;
        }
        if (this.downIsPressed) {
            verticalSpeed = -0.45f;
        }
        this.field_6007 = true;
        this.field_6281 = this.method_6029() * 0.1f;
        if (this.method_5787()) {
            this.method_6125(this.getSpeed() / 2.0f + this.bonusSpeed / 2.0f);
            super.method_6091(new class_243((double)(-forwardSpeed), (double)verticalSpeed, 0.0));
        } else if (livingEntity instanceof class_1657) {
            this.method_18799(class_243.field_1353);
        }
        this.method_29242((class_1309)this, false);
        this.method_36974();
    }

    private void checkBonusValues() {
        class_1657 player = (class_1657)this.method_5642();
        if (player.method_6084(class_1304.field_6169)) {
            class_1792 headItem = player.method_6118(class_1304.field_6169).method_7909();
            if (headItem instanceof WitchHat) {
                this.bonusSpeed = ((WitchHat)headItem).getBroomSpeedBonus();
                this.bonusAgility = ((WitchHat)headItem).getBroomAgilityBonus();
            } else {
                this.bonusSpeed = 0.0f;
                this.bonusAgility = 0.0f;
            }
        } else {
            this.bonusSpeed = 0.0f;
            this.bonusAgility = 0.0f;
        }
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 0.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23720, (double)0.6f);
    }

    public void method_5865(class_1297 passenger) {
        this.updatePassengerPosition(passenger, class_1297::method_5814);
    }

    private void updatePassengerPosition(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        if (!this.method_5626(passenger)) {
            return;
        }
        double d = this.method_23318() + this.method_5621() + passenger.method_5678();
        positionUpdater.accept(passenger, this.method_23317() + (double)0.1f, d, this.method_23321());
    }

    public double method_5621() {
        return 0.08f;
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_29504() {
        return false;
    }

    public boolean method_5805() {
        return !this.method_31481();
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return 0;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_33190() {
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5788() {
        return true;
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.despawn(player);
            return true;
        }
        super.method_5643(source, amount);
        return false;
    }

    private void despawn(class_1657 player) {
        this.method_31472();
        if (!player.method_31548().method_7394(new class_1799((class_1935)this.sourceItem))) {
            this.method_5706((class_1935)this.sourceItem.method_8389());
        }
    }

    protected <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.method_31483() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.fly_idle", Boolean.valueOf(true)));
        } else if (this.upIsPressed) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.up", Boolean.valueOf(true)));
        } else if (this.downIsPressed) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.down", Boolean.valueOf(true)));
        } else if (((class_1309)Objects.requireNonNull(this.method_5642())).field_6250 > 0.1f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.forward", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.static", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController anim = new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate);
        animationData.addAnimationController(anim);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public abstract float getSpeed();

    public abstract float getRotationSpeed();
}

