/*
 * Decompiled with CFR 0.152.
 */
package net.mindshake.witchmobility.entity;

import java.util.List;
import java.util.Objects;
import net.mindshake.witchmobility.item.armor.WitchHat;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class BroomEntity
extends Mob
implements IAnimatable {
    private boolean upIsPressed;
    private boolean downIsPressed;
    private Player lastPassenger;
    protected Item sourceItem;
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private float bonusSpeed = 0.0f;
    private float bonusAgility = 0.0f;

    protected BroomEntity(EntityType<? extends Mob> entityType, Level world, Item sourceItem) {
        super(entityType, world);
        this.m_20242_(true);
        this.sourceItem = sourceItem;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    protected boolean m_7310_(Entity passenger) {
        List passengers = this.m_20197_();
        return passengers.size() < 1;
    }

    public float m_21223_() {
        return 0.0f;
    }

    public boolean canBeControlledByRider() {
        return this.m_6688_() instanceof Player;
    }

    public InteractionResult m_7111_(Player p_19980_, Vec3 p_19981_, InteractionHand p_19982_) {
        if (!this.f_19853_.m_5776_()) {
            boolean isRiding = p_19980_.m_20329_((Entity)this);
            this.lastPassenger = isRiding ? p_19980_ : this.lastPassenger;
            return isRiding ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }
        return p_19980_.m_20201_() == this.m_20201_() ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.upIsPressed = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            this.downIsPressed = Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
        }
    }

    public void m_7023_(Vec3 p_21280_) {
        if (!this.m_6084_()) {
            return;
        }
        if (!this.m_20160_() || !this.canBeControlledByRider()) {
            return;
        }
        this.checkBonusValues();
        LivingEntity livingEntity = (LivingEntity)this.m_6688_();
        this.f_19859_ = this.m_146908_();
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20885_ = this.f_20883_ = this.m_146908_();
        float sideSpeed = livingEntity.f_20900_ * this.getRotationSpeed() * (1.0f + this.bonusAgility);
        this.m_146922_(this.m_146908_() - sideSpeed);
        float forwardSpeed = livingEntity.f_20902_;
        float verticalSpeed = 0.0f;
        if (forwardSpeed <= 0.0f) {
            forwardSpeed *= 0.25f;
        }
        if (this.upIsPressed) {
            verticalSpeed = 0.45f;
        }
        if (this.downIsPressed) {
            verticalSpeed = -0.45f;
        }
        this.f_19812_ = true;
        this.f_20887_ = this.m_6113_() * 0.075f;
        if (this.m_6109_()) {
            this.m_7910_((this.m_6113_() / 2.0f + this.bonusSpeed / 2.0f) * 0.8f);
            super.m_7023_(new Vec3((double)(-forwardSpeed), (double)verticalSpeed, 0.0));
        } else if (livingEntity instanceof Player) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_21043_((LivingEntity)this, false);
        this.m_146872_();
    }

    private void checkBonusValues() {
        Player player = (Player)this.m_6688_();
        if (player.m_21033_(EquipmentSlot.HEAD)) {
            Item headItem = player.m_6844_(EquipmentSlot.HEAD).m_41720_();
            if (headItem instanceof WitchHat) {
                this.bonusSpeed = ((WitchHat)headItem).getBroomSpeedBonus();
                this.bonusAgility = ((WitchHat)headItem).getBroomAgilityBonus();
            } else {
                this.bonusSpeed = 0.0f;
                this.bonusAgility = 0.0f;
            }
        } else {
            this.bonusSpeed = 0.0f;
            this.bonusAgility = 0.0f;
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 0.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22280_, (double)0.6f);
    }

    public double m_6048_() {
        return 0.08f;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_21224_() {
        return false;
    }

    public boolean m_6084_() {
        return !this.m_213877_();
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6040_() {
        return false;
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        Entity entity = p_21016_.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.despawn(player);
            return true;
        }
        return false;
    }

    private void despawn(Player player) {
        this.m_146870_();
        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)this.sourceItem))) {
            this.m_19998_((ItemLike)this.sourceItem.m_5456_());
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_146895_() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.fly_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.upIsPressed) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.up", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.downIsPressed) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.down", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (((LivingEntity)Objects.requireNonNull(this.m_6688_())).f_20902_ > 0.1f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.forward", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.basic_broom.static", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController anim = new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate);
        animationData.addAnimationController(anim);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public abstract float m_6113_();

    public abstract float getRotationSpeed();
}

