/*
 * Decompiled with CFR 0.152.
 */
package net.mindshake.witchmobility.item.armor;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class WitchHat
extends GeoArmorItem
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final int variant;
    private final float broomSpeedBonus;
    private final float broomAgilityBonus;
    private final String[] tooltipTexts = new String[]{"tooltip.witch_hat.apprentice", "tooltip.witch_hat.amethyst", "tooltip.witch_hat.diamond", "tooltip.witch_hat.gold"};

    public WitchHat(int variant, float broomSpeedBonus, float broomAgilityBonus, ArmorMaterial material, EquipmentSlot slot, Item.Properties settings) {
        super(material, slot, settings);
        this.variant = variant;
        this.broomSpeedBonus = broomSpeedBonus;
        this.broomAgilityBonus = broomAgilityBonus;
    }

    @Nullable
    public SoundEvent m_142602_() {
        return SoundEvents.f_11678_;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        p_41423_.add((Component)Component.m_237115_((String)this.tooltipTexts[this.getVariant()]));
        p_41423_.add((Component)Component.m_237110_((String)"tooltip.broom.speed_bonus", (Object[])new Object[]{Float.toString(this.broomSpeedBonus)}));
        p_41423_.add((Component)Component.m_237110_((String)"tooltip.broom.agility_bonus", (Object[])new Object[]{Float.toString(this.broomAgilityBonus)}));
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
    }

    public int getVariant() {
        return this.variant;
    }

    public float getBroomSpeedBonus() {
        return this.broomSpeedBonus;
    }

    public float getBroomAgilityBonus() {
        return this.broomAgilityBonus;
    }
}

