/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.lists.backend;

import net.minecraftforge.common.ForgeConfigSpec;

public class ArrowConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fletchersTradeXtraArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> explosiveArrowDoesBlockDamage;
    public static final ForgeConfigSpec.ConfigValue<Double> explosiveArrowRadius;
    public static final ForgeConfigSpec.ConfigValue<Boolean> explosiveArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Boolean> lightningArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Double> lightningArrowsDamage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> lightningArrowsVisOnly;
    public static final ForgeConfigSpec.ConfigValue<Boolean> lightningArrowsCausesFire;
    public static final ForgeConfigSpec.ConfigValue<Boolean> torchArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Boolean> slimeArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Integer> slimeArrowsBounceOffWalls;
    public static final ForgeConfigSpec.ConfigValue<Double> slimeArrowsBounceMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Boolean> paddedArrowsFall;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enderArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Double> enderArrowFallDamage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> trackingArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Boolean> vexingArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Integer> vexingArrowsInAndOutMax;
    public static final ForgeConfigSpec.ConfigValue<Boolean> soulTorchArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Boolean> redstoneTorchArrowsEnabled;
    public static final ForgeConfigSpec.ConfigValue<Boolean> atlanteanArrowsEnabled;

    static {
        BUILDER.push("Configurations for Xtra Arrows [Forge Edition]");
        fletchersTradeXtraArrows = BUILDER.comment("Should Fletcher Villagers be allowed to trade Xtra Arrows? This may fix compatibility issues if other mods modify fletcher trading. Note that any villagers that have already generated their trades will maintain them. [True = Yes, False = No]").define("fletchersTradeXtraArrows", true);
        paddedArrowsFall = BUILDER.comment("\nShould Padded Arrows fall off walls? [True = Yes, False = No]").define("paddedArrowsFall", true);
        explosiveArrowsEnabled = BUILDER.comment("\nShould Explosive Arrows be functional? [True = Yes, False = No]").define("explosiveArrowsEnabled", true);
        explosiveArrowDoesBlockDamage = BUILDER.comment("Should explosive arrows do damage to the world? [True = Yes, False = No]").define("explosiveArrowDoesBlockDamage", true);
        explosiveArrowRadius = BUILDER.comment("What Should the radius of the Explosive Arrow explosions be by default? [The higher the number, the bigger the explosion. Default: 2.5]").defineInRange("explosiveArrowRadius", 2.5, 0.0, 1000.0);
        lightningArrowsEnabled = BUILDER.comment("\nShould Lightning Arrows be functional? [True = Yes, False = No]").define("lightningArrowsEnabled", true);
        lightningArrowsVisOnly = BUILDER.comment("Should the lightning bolts of Lightning Arrows be visual-only? If true, lightning bolts from the arrows would not impact the world or damage entities. [True = Yes, False = No]").define("lightningArrowVisOnly", false);
        lightningArrowsCausesFire = BUILDER.comment("Should the lightning bolts of Lightining Arrows cause fire?[True = Yes, False = No]").define("lightningArrowCausesFire", true);
        lightningArrowsDamage = BUILDER.comment("How much damage should the lightning bolts of Lightning Arrows do? [The higher the number, the more the damage. Default: 3.5]").defineInRange("lightningArrowsDamage", 3.5, 0.0, 1000.0);
        torchArrowsEnabled = BUILDER.comment("\nShould Torch Arrows be functional? [True = Yes, False = No]").define("torchArrowsEnabled", true);
        soulTorchArrowsEnabled = BUILDER.comment("\nShould Soul Torch Arrows be functional? [True = Yes, False = No]").define("soulTorchArrowsEnabled", true);
        redstoneTorchArrowsEnabled = BUILDER.comment("\nShould Redstone Torch Arrows be functional? [True = Yes, False = No]").define("redstoneTorchArrowsEnabled", true);
        slimeArrowsEnabled = BUILDER.comment("\nShould Slime Arrows be functional? [True = Yes, False = No]").define("slimeArrowsEnabled", true);
        slimeArrowsBounceOffWalls = BUILDER.comment("What is the maximum amount of times a Slime Arrow should be able to bounce off a wall? [Default: 5]").defineInRange("slimeArrowsBounceOffWalls", 5, 0, 1000);
        slimeArrowsBounceMultiplier = BUILDER.comment("What should the bounce multiplier be valued at? Keep this number positive otherwise things will break. [The greater the value, the further the slime arrow will travel. Default: 10.0]").defineInRange("slimeArrowsBounceMultiplier", 10.0, 0.0, 1000.0);
        enderArrowsEnabled = BUILDER.comment("\nShould Ender Arrows be functional? [True = Yes, False = No]").define("enderArrowsEnabled", true);
        enderArrowFallDamage = BUILDER.comment("How much damage should shooting an Ender Arrow enact upon the shooter? [2 damage = 1 heart, Default: 2.0]").defineInRange("enderArrowFallDamage", 2.0, 0.0, 1000.0);
        trackingArrowsEnabled = BUILDER.comment("\nShould Tracking Arrows be functional? [True = Yes, False = No]").define("trackingArrowsEnabled", true);
        vexingArrowsEnabled = BUILDER.comment("\nShould Vexing Arrows be functional? [True = Yes, False = No]").define("vexingArrowsEnabled", true);
        vexingArrowsInAndOutMax = BUILDER.comment("What is the maximum amount of times a vexing arrow should be able to traverse through blocks [Default: 1]").defineInRange("vexingArrowsInAndOutMax", 1, 0, 1000);
        atlanteanArrowsEnabled = BUILDER.comment("\nShould Atlantean Arrows be functional? [True = Yes, False = No]").define("atlanteanArrowsEnabled", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

