/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.lists.backend.configurations;

import net.minecraftforge.common.ForgeConfigSpec;

public class ArrowServerConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableIronArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableGoldenArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableDiamondArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableNetheriteArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableExplosiveArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> explosiveArrowsDamageBlocks;
    public static final ForgeConfigSpec.ConfigValue<Double> explosiveArrowsRadius;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableLightningArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> lightningArrowsVisualOnly;
    public static final ForgeConfigSpec.ConfigValue<Boolean> lightningArrowsCauseFire;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableTorchArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableRedstoneTorchArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableSoulTorchArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableSlimeArrows;
    public static final ForgeConfigSpec.ConfigValue<Double> slimeArrowsBounceMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Integer> slimeArrowsBounceAmount;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableEnderArrows;
    public static final ForgeConfigSpec.ConfigValue<Double> enderArrowFallDamage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableVexingArrows;
    public static final ForgeConfigSpec.ConfigValue<Integer> vexingPhaseAmount;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableTrackingArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableAtlanteanArrows;
    public static final ForgeConfigSpec.ConfigValue<Double> atlanteanInertia;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableFreezingArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableGravityArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableLanternArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableSoulLanternArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableLifeStealArrows;
    public static final ForgeConfigSpec.ConfigValue<Integer> lifeStealAmount;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableMagneticArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableBreedingArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableCupidsArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableAppleArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableGoldenAppleArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableEnchantedGoldenAppleArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableIncendiaryArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableExtinguishingArrows;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableLeashingArrows;
    public static final ForgeConfigSpec.ConfigValue<Double> lightningArrowsDamageAmount;
    public static final ForgeConfigSpec SPEC;

    static {
        BUILDER.push("Server Config for Xtra Arrows | Be sure config options are saved while world is not open");
        enableIronArrows = BUILDER.comment("If set to false, iron arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableIronArrows", true);
        enableGoldenArrows = BUILDER.comment("If set to false, golden arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableGoldenArrows", true);
        enableDiamondArrows = BUILDER.comment("If set to false, diamond arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableDiamondArrows", true);
        enableNetheriteArrows = BUILDER.comment("If set to false, netherite arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableNetheriteArrows", true);
        enableExplosiveArrows = BUILDER.comment("If set to false, explosive arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableExplosiveArrows", true);
        explosiveArrowsDamageBlocks = BUILDER.comment("If set to false, explosions from explosive arrows will not damage blocks.").worldRestart().define("explosiveArrowsDamageBlocks", true);
        explosiveArrowsRadius = BUILDER.comment("Defines the radius of the explosions caused by explosive arrows.").worldRestart().defineInRange("explosiveArrowsRadius", 2.5, 0.0, 1000.0);
        enableLightningArrows = BUILDER.comment("If set to false, lightning arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLightningArrows", true);
        lightningArrowsVisualOnly = BUILDER.comment("If set to true, the lightning spawned by lightning arrows will have no impact on the world or the entities in it. It will be only appear visually.").worldRestart().define("lightningArrowsVisualOnly", false);
        lightningArrowsCauseFire = BUILDER.comment("If set to false, the lightning spawned by lightning arrows will not cause fire at the point of impact.").worldRestart().define("lightningArrowsCauseFire", true);
        enableTorchArrows = BUILDER.comment("If set to false, torch arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableTorchArrows", true);
        enableRedstoneTorchArrows = BUILDER.comment("If set to false, redstone torch arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableRedstoneTorchArrows", true);
        enableSoulTorchArrows = BUILDER.comment("If set to false, soul torch arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableSoulTorchArrows", true);
        enableSlimeArrows = BUILDER.comment("If set to false, slime arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableSlimeArrows", true);
        slimeArrowsBounceMultiplier = BUILDER.comment("Defines the bounce multiplier of slime arrows.").worldRestart().defineInRange("slimeArrowsBounceMultiplier", 10.0, 0.0, 1000.0);
        slimeArrowsBounceAmount = BUILDER.comment("Defines how many times slime arrows bounce before coming to a stop.").worldRestart().defineInRange("slimeArrowsBounceAmount", 5, 0, 1000);
        enableEnderArrows = BUILDER.comment("If set to false, ender arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableEnderArrows", true);
        enderArrowFallDamage = BUILDER.comment("Defines fall damage caused by teleportation from ender arrows.").worldRestart().defineInRange("enderArrowFallDamage", 2.0, 0.0, 1000.0);
        enableVexingArrows = BUILDER.comment("If set to false, vexing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableVexingArrows", true);
        vexingPhaseAmount = BUILDER.comment("Defines how many times a vexing arrow will phase through connected blocks before coming to a stop.").worldRestart().defineInRange("vexingPhaseAmount", 1, 0, 1000);
        enableTrackingArrows = BUILDER.comment("If set to false, tracking arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableTrackingArrows", true);
        enableAtlanteanArrows = BUILDER.comment("If set to false, atlantean arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableAtlanteanArrows", true);
        atlanteanInertia = BUILDER.comment("Defines underwater inertia for atlantean arrows.").worldRestart().defineInRange("atlanteanInertia", 0.99, 0.0, 0.99);
        enableFreezingArrows = BUILDER.comment("If set to false, freezing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableFreezingArrows", true);
        enableGravityArrows = BUILDER.comment("If set to false, gravity arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableGravityArrows", true);
        enableLanternArrows = BUILDER.comment("If set to false, lantern arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLanternArrows", true);
        enableSoulLanternArrows = BUILDER.comment("If set to false, soul lantern arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableSoulLanternArrows", true);
        enableLifeStealArrows = BUILDER.comment("If set to false, life steal arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLifeStealArrows", true);
        lifeStealAmount = BUILDER.comment("Defines amount of health life steal arrows will steal from target. 1 = 1/6 Current Health, 2 = 1/5 Current Health, 3 = 1/4 Current Health, 4 = 1/3 Current Health").worldRestart().defineInRange("lifeStealAmount", 1, 1, 4);
        enableMagneticArrows = BUILDER.comment("If set to false, magnetic arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableMagneticArrows", true);
        enableBreedingArrows = BUILDER.comment("If set to false, breeding arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableBreedingArrows", true);
        enableCupidsArrows = BUILDER.comment("If set to false, Cupid's arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableCupidsArrows", true);
        enableAppleArrows = BUILDER.comment("If set to false, apple arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableAppleArrows", true);
        enableGoldenAppleArrows = BUILDER.comment("If set to false, golden apple arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableGoldenAppleArrows", true);
        enableEnchantedGoldenAppleArrows = BUILDER.comment("If set to false, enchanted golden apple arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableEnchantedGoldenAppleArrows", true);
        enableIncendiaryArrows = BUILDER.comment("If set to false, incendiary arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableIncendiaryArrows", true);
        enableExtinguishingArrows = BUILDER.comment("If set to false, extinguishing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableExtinguishingArrows", true);
        enableLeashingArrows = BUILDER.comment("If set to false, leashing arrows will fire as if they were vanilla flint arrows.").worldRestart().define("enableLeashingArrows", true);
        lightningArrowsDamageAmount = BUILDER.comment("Defines damage amount caused by lightning caused by lightning arrows.").worldRestart().defineInRange("lightningArrowsDamageAmount", 3.5, 0.0, 1000.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

