/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.specialarrowentities.headless;

import com.morearrows.lists.ArrowItems;
import com.morearrows.lists.Registry;
import com.morearrows.lists.backend.ArrowsAPI;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IncendiaryArrowEntity
extends AbstractArrow {
    public IncendiaryArrowEntity(EntityType<? extends IncendiaryArrowEntity> entType, Level level) {
        super(entType, level);
        this.m_36781_(0.5);
    }

    public IncendiaryArrowEntity(Level level, LivingEntity liveEntity) {
        super((EntityType)Registry.incendiary_arrow.get(), liveEntity, level);
        this.m_36781_(0.5);
        if (liveEntity instanceof Player && ((Player)liveEntity).m_150110_().f_35937_) {
            this.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }

    public IncendiaryArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)Registry.incendiary_arrow.get(), x, y, z, level);
        this.m_36781_(0.5);
    }

    protected void m_5790_(@NotNull EntityHitResult entityRes) {
        super.m_5790_(entityRes);
        this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.applyIncendiaryEffectToSurrounding();
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.applyIncendiaryEffectToSurrounding();
        ArrowsAPI.transformIntoHeadlessArrow(this);
    }

    public void applyIncendiaryEffectToSurrounding() {
        if (!this.f_19853_.f_46443_) {
            AABB aABB = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
            Iterator blockPosIterator = BlockPos.m_121921_((AABB)aABB).iterator();
            List entityList = this.f_19853_.m_45976_(Entity.class, aABB);
            for (Entity entity : entityList) {
                ArrowsAPI.burnNonFireImmuneEntity(entity);
            }
            ArrowsAPI.spawnParticlesInCircle(this.f_19853_, this.m_20182_(), ParticleTypes.f_123801_, 4.0, 120.0);
            while (blockPosIterator.hasNext()) {
                int random;
                int random2;
                BlockPos blockPos = (BlockPos)blockPosIterator.next();
                BlockState blockState = this.f_19853_.m_8055_(blockPos);
                FluidState fluidState = this.f_19853_.m_6425_(blockPos);
                BlockHitResult blockHitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos), Direction.DOWN, blockPos, false);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(this.m_9236_(), null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42409_), blockHitResult);
                Entity entity = this.m_19749_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    blockPlaceContext = new BlockPlaceContext(this.m_9236_(), player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42409_), blockHitResult);
                }
                if (!(this.f_19853_.m_8055_(blockPos).m_60734_() instanceof LiquidBlock) && blockPlaceContext.m_7059_() && BaseFireBlock.m_49255_((Level)this.f_19853_, (BlockPos)blockPos, (Direction)Direction.DOWN) && !this.f_19853_.m_8055_(blockPos.m_7495_()).m_60734_().equals(Blocks.f_50083_) && !this.f_19853_.m_8055_(blockPos.m_7495_()).m_60795_() && (random2 = (int)(Math.random() * 4.0) + 1) == 1) {
                    this.f_19853_.m_46597_(blockPos, Blocks.f_50083_.m_49966_());
                }
                if (blockState.m_60734_() instanceof AbstractCandleBlock && !AbstractCandleBlock.m_151933_((BlockState)blockState) && blockState.m_60819_().m_192917_(Fluids.f_76191_)) {
                    this.f_19853_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)AbstractCandleBlock.f_151895_, (Comparable)Boolean.valueOf(true)));
                    this.m_5496_(SoundEvents.f_11936_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                if ((blockState.m_60713_(Blocks.f_50683_) || blockState.m_60713_(Blocks.f_50684_)) && !CampfireBlock.m_51319_((BlockState)blockState) && blockState.m_60819_().m_192917_(Fluids.f_76191_)) {
                    this.f_19853_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true)));
                    this.m_5496_(SoundEvents.f_11936_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                if (!ArrowsAPI.isValidForLiquidBlockReplacement(blockPos, this.f_19853_, blockState, fluidState, Blocks.f_50652_, Blocks.f_49990_) || (random = (int)(Math.random() * 4.0) + 1) != 1) continue;
                this.f_19853_.m_46597_(blockPos, Blocks.f_50652_.m_49966_());
                this.m_5496_(SoundEvents.f_11936_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ArrowItems.incendiary_arrow);
    }
}

