/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.client.util;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.client.util.ImageUtil;
import com.bawnorton.allthetrims.util.DebugHelper;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5253;
import net.minecraft.class_763;
import net.minecraft.class_7764;
import net.minecraft.class_7923;
import net.minecraft.class_918;

public abstract class PaletteHelper {
    private static final Map<class_2960, List<Color>> PALETTES = new HashMap<class_2960, List<Color>>();
    private static final List<Color> BLANK_PALETTE = new ArrayList<Color>();
    public static final List<Color> WHITE_PALETTE = class_2371.method_10213((int)8, (Object)new Color(255, 255, 255));

    public static boolean paletteExists(class_2960 identifier) {
        return PALETTES.containsKey(identifier);
    }

    public static List<Color> getPalette(class_1792 item) {
        return PaletteHelper.getPalette(class_7923.field_41178.method_10221((Object)item));
    }

    public static List<Color> getPalette(class_2960 identifier) {
        if (PALETTES.containsKey(identifier)) {
            return PALETTES.get(identifier);
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_763 models = itemRenderer.method_4012();
        class_1087 model = models.method_3304(item);
        if (model == null) {
            AllTheTrims.LOGGER.warn("Item " + item.method_7848().getString() + " has no model, using blank palette", new Object[0]);
            PaletteHelper.putPalette(identifier, BLANK_PALETTE);
            return BLANK_PALETTE;
        }
        class_1058 sprite = model.method_4711();
        if (sprite == null) {
            AllTheTrims.LOGGER.warn("Model of item " + item.method_7848().getString() + " has no particle sprite, using blank palette", new Object[0]);
            PaletteHelper.putPalette(identifier, BLANK_PALETTE);
            return BLANK_PALETTE;
        }
        class_7764 content = sprite.method_45851();
        if (content.method_45817().count() <= 0L) {
            AllTheTrims.LOGGER.warn("Sprite of item " + item.method_7848().getString() + " has no frames, using blank palette", new Object[0]);
            PaletteHelper.putPalette(identifier, BLANK_PALETTE);
            return BLANK_PALETTE;
        }
        PaletteHelper.putPalette(identifier, PaletteGenerator.generatePalette(content.field_40539));
        return PALETTES.get(identifier);
    }

    public static void putPalette(class_2960 identifier, List<Color> palette) {
        DebugHelper.savePalette(ImageUtil.colourListToPaletteImage(palette), String.valueOf(identifier) + ".png");
        PALETTES.put(identifier, palette);
    }

    public static List<Color> existingResourceToPalette(class_3298 resource) {
        try {
            return PaletteGenerator.toPalette(class_1011.method_4309((InputStream)resource.method_14482()));
        }
        catch (Exception e) {
            AllTheTrims.LOGGER.error("Failed to read palette image", e);
            return BLANK_PALETTE;
        }
    }

    static {
        for (int i = 8; i > 0; --i) {
            BLANK_PALETTE.add(new Color(255 - 255 / i, 255 - 255 / i, 255 - 255 / i));
        }
    }

    private static abstract class PaletteGenerator {
        private PaletteGenerator() {
        }

        public static List<Color> generatePalette(class_1011 image) {
            HashMap<Color, Integer> colourMap = new HashMap<Color, Integer>();
            for (int x = 0; x < image.method_4307(); ++x) {
                for (int y = 0; y < image.method_4323(); ++y) {
                    int pixel = image.method_4315(x, y);
                    int a = pixel >> 24 & 0xFF;
                    if (a < 5) continue;
                    int[] argb = new int[]{a, pixel & 0xFF, pixel >> 8 & 0xFF, pixel >> 16 & 0xFF};
                    Color colour = new Color(class_5253.class_5254.method_27764((int)argb[0], (int)argb[1], (int)argb[2], (int)argb[3]), true);
                    colourMap.put(colour, colourMap.getOrDefault(colour, 0) + 1);
                }
            }
            return PaletteGenerator.coloursToPalette(PaletteGenerator.removeGreys(new ArrayList<Color>(colourMap.keySet())));
        }

        private static List<Color> removeGreys(List<Color> colours) {
            ArrayList<Color> greys = new ArrayList<Color>();
            for (Color colour : colours) {
                float[] hsb = Color.RGBtoHSB(colour.getRed(), colour.getGreen(), colour.getBlue(), null);
                if (!((double)hsb[1] < 0.2)) continue;
                greys.add(colour);
            }
            colours.removeAll(greys);
            if (colours.size() == 0) {
                return greys;
            }
            return colours;
        }

        private static List<Color> coloursToPalette(List<Color> colours) {
            colours.sort(Comparator.comparing(color -> {
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                return Float.valueOf(hsb[1]);
            }));
            Color darkest = colours.get(0);
            darkest = ImageUtil.changeBrightness(darkest, 0.95f);
            Color lightest = colours.get(colours.size() - 1);
            lightest = ImageUtil.changeBrightness(lightest, 1.05f);
            return PaletteGenerator.stretchColors(darkest, lightest);
        }

        private static List<Color> stretchColors(Color ... originalColors) {
            ArrayList<Color> stretchedColors = new ArrayList<Color>();
            int segmentCount = 7;
            double segmentSize = (double)segmentCount / (double)(originalColors.length - 1);
            for (int i = 0; i < originalColors.length - 1; ++i) {
                Color startColor = originalColors[i];
                Color endColor = originalColors[i + 1];
                int j = 0;
                while ((double)j < segmentSize) {
                    float ratio = (float)j / (float)segmentSize;
                    int red = (int)((float)startColor.getRed() + ratio * (float)(endColor.getRed() - startColor.getRed()));
                    int green = (int)((float)startColor.getGreen() + ratio * (float)(endColor.getGreen() - startColor.getGreen()));
                    int blue = (int)((float)startColor.getBlue() + ratio * (float)(endColor.getBlue() - startColor.getBlue()));
                    stretchedColors.add(new Color(red, green, blue));
                    ++j;
                }
            }
            stretchedColors.add(originalColors[originalColors.length - 1]);
            return stretchedColors;
        }

        public static List<Color> toPalette(class_1011 image) {
            if (image.method_4307() != 8 || image.method_4323() != 1) {
                AllTheTrims.LOGGER.warn("Palette image is not 8x1 pixels, using blank palette", new Object[0]);
                return BLANK_PALETTE;
            }
            ArrayList<Color> palette = new ArrayList<Color>();
            for (int x = 0; x < image.method_4307(); ++x) {
                int pixel = image.method_4315(x, 0);
                int a = pixel >> 24 & 0xFF;
                if (a < 5) continue;
                int[] argb = new int[]{a, pixel & 0xFF, pixel >> 8 & 0xFF, pixel >> 16 & 0xFF};
                Color colour = new Color(class_5253.class_5254.method_27764((int)argb[0], (int)argb[1], (int)argb[2], (int)argb[3]), true);
                palette.add(colour);
            }
            return palette;
        }
    }
}

