/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.Compat;
import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1092;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5151;
import net.minecraft.class_7923;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1092.class})
public abstract class BakedModelManagerMixin {
    @ModifyExpressionValue(method={"method_45895(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceFinder;findResources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;")})
    private static Map<class_2960, class_3298> addTrimModels(Map<class_2960, class_3298> original) {
        HashSet equipmentSet = new HashSet();
        class_7923.field_41178.forEach(item -> {
            if (item instanceof class_5151) {
                class_5151 equipment = (class_5151)item;
                equipmentSet.add(equipment);
            }
        });
        for (class_5151 equipment : equipmentSet) {
            class_3298 resource;
            String armourType;
            class_2960 equipmentId = class_7923.field_41178.method_10221((Object)((class_1792)equipment));
            if (equipmentId.method_12836().equals("betterend")) continue;
            class_2960 resourceId = new class_2960(equipmentId.method_12836(), "models/item/" + equipmentId.method_12832() + ".json");
            switch (equipment.method_7685()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_6169: {
                    String string = "helmet";
                    break;
                }
                case field_6174: {
                    String string = "chestplate";
                    break;
                }
                case field_6172: {
                    String string = "leggings";
                    break;
                }
                case field_6166: {
                    String string = "boots";
                    break;
                }
                case field_6173: 
                case field_6171: {
                    String string = armourType = null;
                }
            }
            if (armourType == null) {
                AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + "'s slot type is not an armour slot type, skipping", new Object[0]);
                continue;
            }
            if (class_7923.field_41178.method_10223(equipmentId) instanceof class_1770) {
                if (Compat.isElytraTrimsLoaded()) {
                    armourType = "elytra";
                } else {
                    AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + " is an elytra, but elytratrims is not loaded, skipping", new Object[0]);
                    continue;
                }
            }
            if ((resource = original.get(resourceId)) == null) {
                AllTheTrims.LOGGER.warn("Could not find resource " + String.valueOf(resourceId) + " for item " + String.valueOf(equipmentId) + ", skipping", new Object[0]);
                continue;
            }
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonArray overrides;
                    JsonObject model = JsonHelper.fromJsonReader(reader, JsonObject.class);
                    if (!model.has("textures")) {
                        AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + "'s model does not have a textures parameter, skipping", new Object[0]);
                        continue;
                    }
                    JsonObject textures = model.get("textures").getAsJsonObject();
                    if (!textures.has("layer0")) {
                        AllTheTrims.LOGGER.warn("Item " + String.valueOf(equipmentId) + "'s model does not have a layer0 texture, skipping", new Object[0]);
                        continue;
                    }
                    String baseTexture = textures.get("layer0").getAsString();
                    if (model.has("overrides")) {
                        overrides = model.get("overrides").getAsJsonArray();
                    } else {
                        overrides = new JsonArray();
                        model.add("overrides", (JsonElement)overrides);
                    }
                    JsonObject attOverride = new JsonObject();
                    attOverride.addProperty("model", baseTexture + "_dynamic_trim");
                    JsonObject predicate = new JsonObject();
                    predicate.addProperty("trim_type", "dynamic");
                    attOverride.add("predicate", (JsonElement)predicate);
                    overrides.add((JsonElement)attOverride);
                    JsonObject overrideResourceJson = new JsonObject();
                    overrideResourceJson.addProperty("parent", model.get("parent").getAsString());
                    JsonObject overrideTextures = new JsonObject();
                    overrideTextures.addProperty("layer0", baseTexture);
                    int layer = 1;
                    int trimCount = 0;
                    boolean reachedEnd = false;
                    while (true) {
                        JsonElement layerElement;
                        if ((layerElement = textures.get("layer" + layer)) == null) {
                            reachedEnd = true;
                        } else {
                            overrideTextures.add("layer" + layer, layerElement);
                        }
                        if (reachedEnd) {
                            overrideTextures.addProperty("layer" + layer, "minecraft:trims/items/" + armourType + "_trim_" + trimCount + "_dynamic");
                            if (trimCount == 7) break;
                            ++trimCount;
                        }
                        ++layer;
                    }
                    overrideResourceJson.add("textures", (JsonElement)overrideTextures);
                    class_2960 baseId = new class_2960(baseTexture);
                    class_2960 overrideResourceModelId = baseId.method_45136("models/" + baseId.method_12832() + "_dynamic_trim.json");
                    class_3298 overrideResource = new class_3298(resource.method_45304(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString(overrideResourceJson), (String)"UTF-8"));
                    original.put(overrideResourceModelId, overrideResource);
                    DebugHelper.createDebugFile("models", String.valueOf(equipmentId) + "_dynamic_trim.json", JsonHelper.toJsonString(overrideResourceJson));
                    resource = new class_3298(resource.method_45304(), () -> IOUtils.toInputStream((String)JsonHelper.toJsonString(model), (String)"UTF-8"));
                    DebugHelper.createDebugFile("models", String.valueOf(equipmentId) + ".json", JsonHelper.toJsonString(model));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                    continue;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            original.put(resourceId, resource);
        }
        return original;
    }
}

