/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.client;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.client.util.ImageUtil;
import com.bawnorton.allthetrims.client.util.PaletteHelper;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Function3;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_8066;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_8066.class})
public abstract class PalettedPermutationsAtlasSourceMixin {
    @ModifyArg(method={"method_48487"}, at=@At(value="INVOKE", target="Lcom/mojang/datafixers/Products$P3;apply(Lcom/mojang/datafixers/kinds/Applicative;Lcom/mojang/datafixers/util/Function3;)Lcom/mojang/datafixers/kinds/App;", remap=false), index=1)
    private static <R> Function3<List<class_2960>, class_2960, Map<String, class_2960>, R> createDynamicTrimPermutation(Function3<List<class_2960>, class_2960, Map<String, class_2960>, R> function) {
        return (textures, paletteKey, palettedPermutations) -> {
            if (!paletteKey.method_12832().contains("trim_palette")) {
                return function.apply(textures, paletteKey, palettedPermutations);
            }
            ArrayList<class_2960> newTextures = new ArrayList<class_2960>(textures.size() * 9);
            for (class_2960 texture : textures) {
                newTextures.add(texture);
                for (int i = 0; i < 8; ++i) {
                    newTextures.add(texture.method_48331("_" + i));
                }
            }
            HashMap<String, class_2960> newPermutations = new HashMap<String, class_2960>((Map<String, class_2960>)palettedPermutations);
            newPermutations.put("dynamic", new class_2960("trims/color_palettes/blank"));
            return function.apply(newTextures, paletteKey, newPermutations);
        };
    }

    @ModifyExpressionValue(method={"method_48486"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceManager;getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;")})
    private static Optional<class_3298> addBlankPalette(Optional<class_3298> optionalResource, class_3300 resourceManager, class_2960 identifier) {
        if (optionalResource.isPresent()) {
            String path = identifier.method_12832();
            path = path.substring("trims_color_palettes_".length());
            PaletteHelper.putPalette(identifier.method_45136(path), PaletteHelper.existingResourceToPalette(optionalResource.get()));
            return optionalResource;
        }
        return Optional.of(new class_3298((class_3262)class_310.method_1551().method_45573(), () -> ImageUtil.toInputStream(ImageUtil.newBlankPaletteImage())));
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceManager;getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;"))
    private Optional<class_3298> getLayeredTrimResource(class_3300 instance, class_2960 identifier, @Share(value="identifier") LocalRef<class_2960> identifierRef) {
        Optional<class_3298> optional;
        block12: {
            identifierRef.set((Object)identifier);
            Optional original = instance.method_14486(identifier);
            if (original.isPresent()) {
                return original;
            }
            String path = identifier.method_12832();
            int pathEnd = path.lastIndexOf(95);
            class_2960 originalIdentifier = pathEnd > 0 ? identifier.method_45136(path.substring(0, pathEnd) + ".png") : identifier;
            Optional optionalResource = instance.method_14486(originalIdentifier);
            if (optionalResource.isEmpty()) {
                return optionalResource;
            }
            Pattern pattern = Pattern.compile("\\d+(?![\\d\\D]*\\d)");
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) {
                AllTheTrims.LOGGER.warn("Failed to find layer number in " + path, new Object[0]);
                return optionalResource;
            }
            int layer = Integer.parseInt(matcher.group());
            class_3298 resource = (class_3298)optionalResource.get();
            InputStream inputStream = resource.method_14482();
            try {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage == null) {
                    throw new RuntimeException("Failed to read image from " + String.valueOf(originalIdentifier));
                }
                Color colour = ImageUtil.getNthDarkestColour(bufferedImage, layer);
                BufferedImage newImage = ImageUtil.removeOtherColours(bufferedImage, colour);
                DebugHelper.saveLayeredTexture(newImage, identifier.toString());
                optional = Optional.of(new class_3298(resource.method_45304(), () -> ImageUtil.toInputStream(newImage)));
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    @ModifyExpressionValue(method={"load"}, at={@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;")})
    private Set<Map.Entry<String, Supplier<IntUnaryOperator>>> removeAllNonBlankPalettes(Set<Map.Entry<String, Supplier<IntUnaryOperator>>> permutations, @Share(value="identifier") LocalRef<class_2960> identifierRef) {
        String path = ((class_2960)identifierRef.get()).method_12832();
        String pattern = ".*_\\d.png";
        HashSet<Map.Entry<String, Supplier<IntUnaryOperator>>> newPermutations = new HashSet<Map.Entry<String, Supplier<IntUnaryOperator>>>();
        if (!path.matches(pattern)) {
            for (Map.Entry<String, Supplier<IntUnaryOperator>> entry : permutations) {
                if (entry.getKey().equals("dynamic")) continue;
                newPermutations.add(entry);
            }
        } else {
            for (Map.Entry<String, Supplier<IntUnaryOperator>> entry : permutations) {
                if (!entry.getKey().equals("dynamic")) continue;
                newPermutations.add(entry);
            }
        }
        return newPermutations;
    }
}

