/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin.fabric.client.bclib;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.annotation.ConditionalMixin;
import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1770;
import net.minecraft.class_2960;
import net.minecraft.class_5151;
import net.minecraft.class_7923;
import org.betterx.bclib.client.models.PatternsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@ConditionalMixin(modid="bclib")
@Mixin(value={PatternsHelper.class}, remap=false)
public abstract class PatternsHelperMixin {
    @ModifyReturnValue(method={"createItemGenerated"}, at={@At(value="RETURN")})
    private static Optional<String> addTrimsToArmourItems(Optional<String> original, class_2960 identifier) {
        JsonArray overrides;
        String armourType;
        if (original.isEmpty()) {
            return original;
        }
        class_2960 noInv = identifier.method_45136(identifier.method_12832().replace("#inventory", ""));
        Object object = class_7923.field_41178.method_10223(noInv);
        if (!(object instanceof class_5151)) {
            return original;
        }
        class_5151 equipment = (class_5151)object;
        switch (equipment.method_7685()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_6169: {
                String string = "helmet";
                break;
            }
            case field_6174: {
                String string = "chestplate";
                break;
            }
            case field_6172: {
                String string = "leggings";
                break;
            }
            case field_6166: {
                String string = "boots";
                break;
            }
            case field_6173: 
            case field_6171: {
                String string = armourType = null;
            }
        }
        if (armourType == null) {
            AllTheTrims.LOGGER.warn("Item " + String.valueOf(noInv) + "'s slot type is not an armour slot type, skipping", new Object[0]);
            return original;
        }
        if (equipment instanceof class_1770 && !FabricLoader.getInstance().isModLoaded("elytratrims")) {
            AllTheTrims.LOGGER.warn("Item " + String.valueOf(noInv) + " is an elytra, but elytratrims is not loaded, skipping", new Object[0]);
            return original;
        }
        JsonObject model = JsonHelper.fromJsonString(original.get(), JsonObject.class);
        if (!model.has("textures")) {
            AllTheTrims.LOGGER.warn("Item " + String.valueOf(noInv) + "'s model does not have a textures parameter, skipping", new Object[0]);
            return original;
        }
        JsonObject textures = model.get("textures").getAsJsonObject();
        if (!textures.has("layer0")) {
            AllTheTrims.LOGGER.warn("Item " + String.valueOf(noInv) + "'s model does not have a layer0 texture, skipping", new Object[0]);
            return original;
        }
        String baseTexture = textures.get("layer0").getAsString();
        if (model.has("overrides")) {
            overrides = model.get("overrides").getAsJsonArray();
        } else {
            overrides = new JsonArray();
            model.add("overrides", (JsonElement)overrides);
        }
        JsonObject attOverride = new JsonObject();
        attOverride.addProperty("model", baseTexture + "_dynamic_trim");
        JsonObject predicate = new JsonObject();
        predicate.addProperty("trim_type", "dynamic");
        attOverride.add("predicate", (JsonElement)predicate);
        overrides.add((JsonElement)attOverride);
        DebugHelper.createDebugFile("bclib", String.valueOf(noInv) + ".json", JsonHelper.toJsonString(model));
        return Optional.of(JsonHelper.toJsonString(model));
    }
}

