/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.client.util;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.client.util.ImageUtil;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;

public abstract class PaletteHelper {
    private static final Map<ResourceLocation, List<Color>> PALETTES = new HashMap<ResourceLocation, List<Color>>();
    private static final List<Color> BLANK_PALETTE = new ArrayList<Color>();
    public static final List<Color> WHITE_PALETTE = NonNullList.m_122780_((int)8, (Object)new Color(255, 255, 255));

    public static boolean paletteExists(ResourceLocation identifier) {
        return PALETTES.containsKey(identifier);
    }

    public static List<Color> getPalette(Item item) {
        return PaletteHelper.getPalette(BuiltInRegistries.f_257033_.m_7981_((Object)item));
    }

    public static List<Color> getPalette(ResourceLocation identifier) {
        if (PALETTES.containsKey(identifier)) {
            return PALETTES.get(identifier);
        }
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(identifier);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemModelShaper models = itemRenderer.m_115103_();
        BakedModel model = models.m_109394_(item);
        if (model == null) {
            AllTheTrims.LOGGER.warn("Item " + item.m_41466_().getString() + " has no model, using blank palette", new Object[0]);
            PaletteHelper.putPalette(identifier, BLANK_PALETTE);
            return BLANK_PALETTE;
        }
        TextureAtlasSprite sprite = model.m_6160_();
        if (sprite == null) {
            AllTheTrims.LOGGER.warn("Model of item " + item.m_41466_().getString() + " has no particle sprite, using blank palette", new Object[0]);
            PaletteHelper.putPalette(identifier, BLANK_PALETTE);
            return BLANK_PALETTE;
        }
        SpriteContents content = sprite.m_245424_();
        if (content.m_245638_().count() <= 0L) {
            AllTheTrims.LOGGER.warn("Sprite of item " + item.m_41466_().getString() + " has no frames, using blank palette", new Object[0]);
            PaletteHelper.putPalette(identifier, BLANK_PALETTE);
            return BLANK_PALETTE;
        }
        PaletteHelper.putPalette(identifier, PaletteGenerator.generatePalette(content.f_243904_));
        return PALETTES.get(identifier);
    }

    public static void putPalette(ResourceLocation identifier, List<Color> palette) {
        DebugHelper.savePalette(ImageUtil.colourListToPaletteImage(palette), String.valueOf(identifier) + ".png");
        PALETTES.put(identifier, palette);
    }

    public static List<Color> existingResourceToPalette(Resource resource) {
        try {
            return PaletteGenerator.toPalette(NativeImage.m_85058_((InputStream)resource.m_215507_()));
        }
        catch (Exception e) {
            AllTheTrims.LOGGER.error("Failed to read palette image", e);
            return BLANK_PALETTE;
        }
    }

    static {
        for (int i = 8; i > 0; --i) {
            BLANK_PALETTE.add(new Color(255 - 255 / i, 255 - 255 / i, 255 - 255 / i));
        }
    }

    private static abstract class PaletteGenerator {
        private PaletteGenerator() {
        }

        public static List<Color> generatePalette(NativeImage image) {
            HashMap<Color, Integer> colourMap = new HashMap<Color, Integer>();
            for (int x = 0; x < image.m_84982_(); ++x) {
                for (int y = 0; y < image.m_85084_(); ++y) {
                    int pixel = image.m_84985_(x, y);
                    int a = pixel >> 24 & 0xFF;
                    if (a < 5) continue;
                    int[] argb = new int[]{a, pixel & 0xFF, pixel >> 8 & 0xFF, pixel >> 16 & 0xFF};
                    Color colour = new Color(FastColor.ARGB32.m_13660_((int)argb[0], (int)argb[1], (int)argb[2], (int)argb[3]), true);
                    colourMap.put(colour, colourMap.getOrDefault(colour, 0) + 1);
                }
            }
            return PaletteGenerator.coloursToPalette(PaletteGenerator.removeGreys(new ArrayList<Color>(colourMap.keySet())));
        }

        private static List<Color> removeGreys(List<Color> colours) {
            ArrayList<Color> greys = new ArrayList<Color>();
            for (Color colour : colours) {
                float[] hsb = Color.RGBtoHSB(colour.getRed(), colour.getGreen(), colour.getBlue(), null);
                if (!((double)hsb[1] < 0.2)) continue;
                greys.add(colour);
            }
            colours.removeAll(greys);
            if (colours.size() == 0) {
                return greys;
            }
            return colours;
        }

        private static List<Color> coloursToPalette(List<Color> colours) {
            colours.sort(Comparator.comparing(color -> {
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                return Float.valueOf(hsb[1]);
            }));
            Color darkest = colours.get(0);
            darkest = ImageUtil.changeBrightness(darkest, 0.95f);
            Color lightest = colours.get(colours.size() - 1);
            lightest = ImageUtil.changeBrightness(lightest, 1.05f);
            return PaletteGenerator.stretchColors(darkest, lightest);
        }

        private static List<Color> stretchColors(Color ... originalColors) {
            ArrayList<Color> stretchedColors = new ArrayList<Color>();
            int segmentCount = 7;
            double segmentSize = (double)segmentCount / (double)(originalColors.length - 1);
            for (int i = 0; i < originalColors.length - 1; ++i) {
                Color startColor = originalColors[i];
                Color endColor = originalColors[i + 1];
                int j = 0;
                while ((double)j < segmentSize) {
                    float ratio = (float)j / (float)segmentSize;
                    int red = (int)((float)startColor.getRed() + ratio * (float)(endColor.getRed() - startColor.getRed()));
                    int green = (int)((float)startColor.getGreen() + ratio * (float)(endColor.getGreen() - startColor.getGreen()));
                    int blue = (int)((float)startColor.getBlue() + ratio * (float)(endColor.getBlue() - startColor.getBlue()));
                    stretchedColors.add(new Color(red, green, blue));
                    ++j;
                }
            }
            stretchedColors.add(originalColors[originalColors.length - 1]);
            return stretchedColors;
        }

        public static List<Color> toPalette(NativeImage image) {
            if (image.m_84982_() != 8 || image.m_85084_() != 1) {
                AllTheTrims.LOGGER.warn("Palette image is not 8x1 pixels, using blank palette", new Object[0]);
                return BLANK_PALETTE;
            }
            ArrayList<Color> palette = new ArrayList<Color>();
            for (int x = 0; x < image.m_84982_(); ++x) {
                int pixel = image.m_84985_(x, 0);
                int a = pixel >> 24 & 0xFF;
                if (a < 5) continue;
                int[] argb = new int[]{a, pixel & 0xFF, pixel >> 8 & 0xFF, pixel >> 16 & 0xFF};
                Color colour = new Color(FastColor.ARGB32.m_13660_((int)argb[0], (int)argb[1], (int)argb[2], (int)argb[3]), true);
                palette.add(colour);
            }
            return palette;
        }
    }
}

