/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin;

import com.bawnorton.allthetrims.AllTheTrims;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.bawnorton.allthetrims.util.TrimMaterialHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={RegistryDataLoader.class})
public abstract class RegistryLoaderMixin {
    @ModifyExpressionValue(method={"load(Lnet/minecraft/registry/RegistryOps$RegistryInfoGetter;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/registry/MutableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceFinder;findResources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;")})
    private static Map<ResourceLocation, Resource> addAllTrimMaterialJsonFiles(Map<ResourceLocation, Resource> original) {
        Iterator<Map.Entry<ResourceLocation, Resource>> iterator = original.entrySet().iterator();
        if (!iterator.hasNext()) {
            return original;
        }
        Map.Entry<ResourceLocation, Resource> first = original.entrySet().iterator().next();
        if (!first.getKey().m_135815_().contains("trim_material")) {
            return original;
        }
        TrimMaterialHelper.loopTrimMaterials(item -> {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_(item);
            JsonObject resourceJson = new JsonObject();
            try {
                resourceJson.addProperty("asset_name", "dynamic");
                JsonObject description = new JsonObject();
                description.addProperty("color", "#FFFFFF");
                description.addProperty("translate", RegistryLoaderMixin.allTheTrims$escape(item.m_41466_().getString()) + " " + RegistryLoaderMixin.allTheTrims$escape(Component.m_237115_((String)"text.allthetrims.material").getString()));
                resourceJson.add("description", (JsonElement)description);
                resourceJson.addProperty("ingredient", itemId.toString());
                resourceJson.addProperty("item_model_index", (Number)Float.valueOf(Float.MAX_VALUE));
            }
            catch (RuntimeException e) {
                AllTheTrims.LOGGER.error("Failed to generate trim material JSON for " + String.valueOf(itemId), e);
                return;
            }
            Resource resource = new Resource(((Resource)first.getValue()).m_247173_(), () -> IOUtils.toInputStream((String)resourceJson.toString(), (String)"UTF-8"));
            ResourceLocation resourceId = new ResourceLocation(itemId.m_135827_(), "trim_material/" + itemId.m_135815_() + ".json");
            original.put(resourceId, resource);
            DebugHelper.createDebugFile("trim_materials", String.valueOf(itemId) + ".json", resourceJson.toString());
        });
        return original;
    }

    @Unique
    private static String allTheTrims$escape(String string) {
        return string.replace("\"", "\\\"");
    }
}

